/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.compat;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import tschipp.carryon.Constants;
import tschipp.carryon.platform.Services;

public class ArchitecturyCompat {
    private static Object INVOKER_INSTANCE;
    private static Method PLACE_BLOCK;
    private static Method IS_FALSE;

    private static void setup() {
        try {
            Class<?> BlockEvent = Class.forName("dev.architectury.event.events.common.BlockEvent");
            Field PLACE = BlockEvent.getField("PLACE");
            Method invoker = Class.forName("dev.architectury.event.Event").getMethod("invoker", new Class[0]);
            INVOKER_INSTANCE = invoker.invoke(PLACE.get(BlockEvent), new Object[0]);
            Class<?> PlaceClass = Class.forName("dev.architectury.event.events.common.BlockEvent$Place");
            PLACE_BLOCK = PlaceClass.getMethod("placeBlock", class_1937.class, class_2338.class, class_2680.class, class_1297.class);
            Class<?> EventResult = Class.forName("dev.architectury.event.EventResult");
            IS_FALSE = EventResult.getMethod("isFalse", new Class[0]);
        }
        catch (Exception e) {
            Constants.LOG.warn("Error while initializing Architectury Compat: " + String.valueOf(e));
        }
    }

    public static boolean active() {
        return Services.PLATFORM.isModLoaded("architectury");
    }

    public static boolean sendPlaceEvent(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (!ArchitecturyCompat.active()) {
            return true;
        }
        if (INVOKER_INSTANCE == null || PLACE_BLOCK == null) {
            ArchitecturyCompat.setup();
        }
        if (INVOKER_INSTANCE != null && PLACE_BLOCK != null && IS_FALSE != null) {
            try {
                Object eventResult = PLACE_BLOCK.invoke(INVOKER_INSTANCE, level, pos, state, player);
                boolean canceled = (Boolean)IS_FALSE.invoke(eventResult, new Object[0]);
                return !canceled;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }
}

