/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.platform;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking.PlayPayloadHandler;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import tschipp.carryon.CarryOnFabricClientMod;
import tschipp.carryon.config.BuiltConfig;
import tschipp.carryon.config.fabric.ConfigLoaderImpl;
import tschipp.carryon.networking.PacketBase;
import tschipp.carryon.platform.services.IPlatformHelper;

import java.util.function.BiConsumer;
import java.util.function.Function;

public class FabricPlatformHelper implements IPlatformHelper {

    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {

        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {

        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public void registerConfig(BuiltConfig cfg) {
        ConfigLoaderImpl.registerConfig(cfg);
    }

    @Override
    public <T extends PacketBase, B extends class_2540> void  registerServerboundPacket(class_8710.class_9154<T> type, Class<T> clazz, class_9139<B, T> codec, BiConsumer<T, class_1657> handler, Object... args)
    {
        PayloadTypeRegistry.playC2S().register(type, (class_9139<class_9129, T>)codec);

        ServerPlayNetworking.registerGlobalReceiver(type, (T packet, ServerPlayNetworking.Context context) -> {
            context.server().execute(() -> {
                handler.accept(packet, context.player());
            });
        });
    }

    @Override
    public <T extends PacketBase, B extends class_2540> void  registerClientboundPacket(class_8710.class_9154<T> type, Class<T> clazz, class_9139<B, T> codec, BiConsumer<T, class_1657> handler, Object... args)
    {
        boolean client = (boolean)args[0];

        if(!client)
            PayloadTypeRegistry.playS2C().register(type, (class_9139<class_9129, T>)codec);
        else
            CarryOnFabricClientMod.registerClientboundPacket(type, handler);
    }

    @Override
    public void sendPacketToServer(class_2960 id, PacketBase packet)
    {
        CarryOnFabricClientMod.sendPacketToServer(packet);
    }

    @Override
    public void sendPacketToPlayer(class_2960 id, PacketBase packet, class_3222 player)
    {
        ServerPlayNetworking.send(player, packet);
    }
}
