/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.common.scripting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import org.jetbrains.annotations.NotNull;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.networking.clientbound.ClientboundSyncScriptsPacket;
import tschipp.carryon.platform.Services;

import java.util.Collections;
import java.util.Map;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7654;

public class ScriptReloadListener extends class_4309<CarryOnScript>
{
	public ScriptReloadListener()
	{
		super(CarryOnScript.CODEC, class_7654.method_45114("carryon/scripts"));
	}

	@Override
	protected void apply(Map<class_2960, CarryOnScript> scripts, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller)
	{
		ScriptManager.SCRIPTS.clear();

		scripts.forEach((path, script) -> {
			if (script.isValid())
				ScriptManager.SCRIPTS.add(script);
		});

		ScriptManager.SCRIPTS.sort((s1, s2) -> Long.compare(s2.priority(), s1.priority()));
	}


	public static void syncScriptsWithClient(class_3222 player)
	{
		if (player != null)
		{
			DataResult<class_2520> result = Codec.list(CarryOnScript.CODEC).encodeStart(class_2509.field_11560, ScriptManager.SCRIPTS);
			class_2520 tag = result.getOrThrow(s -> {throw new RuntimeException("Error while synching Carry On Scripts: " + s);});

			Services.PLATFORM.sendPacketToPlayer(Constants.PACKET_ID_SYNC_SCRIPTS, new ClientboundSyncScriptsPacket(tag), player);
		}
	}
}

