/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.client.keybinds;

import tschipp.carryon.Constants;
import tschipp.carryon.networking.serverbound.ServerboundCarryKeyPressedPacket;
import tschipp.carryon.platform.Services;

import java.util.function.Consumer;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public class CarryOnKeybinds
{
	public static class_304 carryKey;

	public static void registerKeybinds(Consumer<class_304> registrar)
	{
		if(Services.PLATFORM.isModLoaded("amecsapi"))
			carryKey = new ConflictFreeKeyMapping("key.carry.desc", class_3675.field_31951, "key.carry.category");
		else
			carryKey = new ConflictFreeKeyMapping("key.carry.desc", Services.PLATFORM.getPlatformName().equals("Forge") ? class_3675.field_31951 : class_3675.field_16237.method_1444(), "key.carry.category");

		registrar.accept(carryKey);
	}

	public static void onCarryKey(boolean pressed)
	{
		Services.PLATFORM.sendPacketToServer(Constants.PACKET_ID_KEY_PRESSED, new ServerboundCarryKeyPressedPacket(pressed));
	}

}
