/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon;

import net.minecraft.class_1657;
import net.minecraft.class_310;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;

public class CarryOnCommonClient
{
	public static void checkForKeybinds()
	{
		class_310 mc = class_310.method_1551();
		class_1657 player = mc.field_1724;
		if(player != null) {
			CarryOnData carry = CarryOnDataManager.getCarryData(player);
			if ((CarryOnKeybinds.carryKey.method_1415() ? player.method_5715() : (CarryOnKeybinds.carryKey.method_1434() || checkMouse())) && !carry.isKeyPressed()) {
				CarryOnKeybinds.onCarryKey(true);
				carry.setKeyPressed(true);
				CarryOnDataManager.setCarryData(player, carry);
			} else if (!(CarryOnKeybinds.carryKey.method_1415() ? player.method_5715() : (CarryOnKeybinds.carryKey.method_1434() || checkMouse()) ) && carry.isKeyPressed()) {
				CarryOnKeybinds.onCarryKey(false);
				carry.setKeyPressed(false);
				CarryOnDataManager.setCarryData(player, carry);
			}
		}
	}

	private static boolean checkMouse()
	{
		class_310 mc = class_310.method_1551();
		return (CarryOnKeybinds.carryKey.method_1433(0) && mc.field_1729.method_1608()) || (CarryOnKeybinds.carryKey.method_1433(1) && mc.field_1729.method_1609()) || (CarryOnKeybinds.carryKey.method_1433(3) && mc.field_1729.method_35707());
	}

	public static void onCarryClientTick()
	{
		class_1657 player = class_310.method_1551().field_1724;
		if(player != null) {
			CarryOnData carry = CarryOnDataManager.getCarryData(player);
			if(carry.isCarrying())
			{
				player.method_31548().field_7545 = carry.getSelected();
			}
		}
	}

	public static class_1657 getPlayer()
	{
		return class_310.method_1551().field_1724;
	}
}
