/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.networking.clientbound;

import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import tschipp.carryon.Constants;
import tschipp.carryon.networking.PacketBase;

public record ClientboundStartRidingOtherPlayerPacket(int mount, int rider, boolean ride) implements PacketBase
{
	public static final class_9139<class_9129, ClientboundStartRidingOtherPlayerPacket> CODEC = class_9139.method_56436(
			class_9135.field_49675, ClientboundStartRidingOtherPlayerPacket::mount,
			class_9135.field_49675, ClientboundStartRidingOtherPlayerPacket::rider,
			class_9135.field_48547, ClientboundStartRidingOtherPlayerPacket::ride,
			ClientboundStartRidingOtherPlayerPacket::new
	);

	public static final class_9154<ClientboundStartRidingOtherPlayerPacket> TYPE = new class_9154<>(Constants.PACKET_ID_START_RIDING_OTHER);

	@Override
	public void handle(class_1657 player)
	{
		class_1297 mount = player.method_73183().method_8469(this.mount);
		class_1297 rider = player.method_73183().method_8469(this.rider);

		if(mount != null && rider != null)
			if(ride)
				rider.method_5873(mount, true,true);
			else
				rider.method_5848();
	}

	@Override
	public class_9154<ClientboundStartRidingOtherPlayerPacket> method_56479() {
		return TYPE;
	}
}
