/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import tschipp.carryon.Constants;
import tschipp.carryon.client.modeloverride.ModelOverride;
import tschipp.carryon.client.modeloverride.ModelOverrideHandler;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnData.CarryType;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.carry.PlacementHandler;
import tschipp.carryon.common.pickupcondition.PickupCondition;
import tschipp.carryon.common.pickupcondition.PickupConditionHandler;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.class_12087;
import net.minecraft.class_12094;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class CommandCarryOn
{
	public static void register(CommandDispatcher<class_2168> dispatcher)
	{
		LiteralArgumentBuilder<class_2168> builder = class_2170.method_9247("carryon")

				.then(class_2170.method_9247("debug").executes(cmd -> handleDebug(cmd.getSource())))

				.then(class_2170.method_9247("clear").executes(cmd -> handleClear(cmd.getSource(), Collections.singleton(cmd.getSource().method_9207()))))

				.then(class_2170.method_9247("clear").then(class_2170.method_9244("target", class_2186.method_9308()).requires(src -> src.method_75037().hasPermission(new class_12087.class_12089(class_12094.field_63198))).executes(cmd -> handleClear(cmd.getSource(), class_2186.method_9312(cmd, "target")))))

				.then(class_2170.method_9247("place").requires(src -> src.method_75037().hasPermission(new class_12087.class_12089(class_12094.field_63198))).executes(cmd -> handlePlace(cmd.getSource(), Collections.singleton(cmd.getSource().method_9207()))))

				.then(class_2170.method_9247("place").then(class_2170.method_9244("target", class_2186.method_9308()).requires(src -> src.method_75037().hasPermission(new class_12087.class_12089(class_12094.field_63198))).executes(cmd -> handlePlace(cmd.getSource(), class_2186.method_9312(cmd, "target")))))

				;

		dispatcher.register(builder);

	}

	private static int handleDebug(class_2168 source)
	{
		try
		{
			if (source.method_9229() != null)
			{
				class_3222 player = source.method_9207();

				CarryOnData carry = CarryOnDataManager.getCarryData(player);
				if (carry.isCarrying(CarryType.BLOCK))
				{
					class_2680 block = carry.getBlock();
					log(source,"Block: " + block.method_26204());
					log(source,"BlockState: " + block);
					log(source,"NBT: " + carry.getNbt());

					Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(block, carry.getContentNbt());
					if(ov.isPresent())
						log(source, "Override Model: " + ov.get().getRenderObject());

					Optional<PickupCondition> cond = PickupConditionHandler.getPickupCondition(block);
					if(cond.isPresent())
						log(source, "Custom Pickup Condition: " + cond.get().getCondition());


					return 1;
				}
				else if (carry.isCarrying(CarryType.ENTITY))
				{
					class_1297 entity = carry.getEntity(player.method_51469());
					log(source,"Entity: " + entity);
					log(source,"Entity Name: " + entity.method_5864());
					log(source,"NBT: " + carry.getNbt());

					Optional<PickupCondition> cond = PickupConditionHandler.getPickupCondition(entity);
					if(cond.isPresent())
						log(source, "Custom Pickup Condition: " + cond.get().getCondition());

					return 1;
				}
				else if(carry.isCarrying(CarryType.PLAYER))
				{
					log(source, "Carrying Player.");
				}
			}

		}
		catch (CommandSyntaxException e)
		{
		}

		return 0;
	}

	private static int handleClear(class_2168 source, Collection<class_3222> players)
	{
		int cleared = 0;
		for (class_3222 player : players)
		{

			CarryOnData carry = CarryOnDataManager.getCarryData(player);
			carry.clear();
			CarryOnDataManager.setCarryData(player, carry);

			cleared++;
		}
		int finalCleared = cleared;

		if (cleared != 1) {
			source.method_9226(() -> class_2561.method_43470("Cleared " + finalCleared + " Items!"), true);
		}
		else {
			source.method_9226(() -> class_2561.method_43470("Cleared " + finalCleared + " Item!"), true);
		}

		return 1;
	}

	private static int handlePlace(class_2168 source, Collection<class_3222> players)
	{
		int cleared = 0;
		for (class_3222 player : players)
		{
			PlacementHandler.placeCarried(player);
			cleared++;
		}
		int finalCleared = cleared;

		if (cleared != 1) {
			source.method_9226(() -> class_2561.method_43470("Placed " + finalCleared + " Items!"), true);
		}
		else
			source.method_9226(() -> class_2561.method_43470("Placed " + finalCleared + " Item!"), true);

		return 1;
	}

	private static void log(class_2168 source, String toLog)
	{
		source.method_9226(() -> class_2561.method_43470(toLog), true);
		Constants.LOG.info(toLog);
	}
}
