/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.pickupcondition;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2259;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import tschipp.carryon.platform.Services;
import tschipp.carryon.utils.StringHelper;

public class PickupCondition {
    public static Codec<PickupCondition> CODEC = Codec.STRING.comapFlatMap(PickupCondition::of, pickupCondition -> pickupCondition.str);
    private String str;
    private String cond;
    private String match;
    private boolean wildcards;

    private PickupCondition(String str, String cond, String match) {
        this.str = str;
        this.cond = cond;
        this.match = match;
    }

    public static DataResult<PickupCondition> of(String str) {
        if (!str.contains("(") || !str.endsWith(")")) {
            return DataResult.error(() -> "Error while parsing: " + str + ". Pickup Condition must contain proper brackets.");
        }
        String cond = str.substring(str.indexOf("(") + 1, str.length() - 1);
        String match = str.substring(0, str.indexOf("("));
        PickupCondition condition = new PickupCondition(str, cond, match);
        if (match.contains("*")) {
            condition.wildcards = true;
        }
        return DataResult.success((Object)condition);
    }

    public boolean matches(class_2680 state) {
        if (this.wildcards) {
            String name = this.match.contains("[") ? this.match.substring(0, this.match.indexOf("[")) : this.match;
            String[] split = name.replace("*", ",").split(",");
            Object stateName = class_7923.field_41175.method_10221((Object)state.method_26204()).toString();
            if (StringHelper.matchesWildcards((String)stateName, split)) {
                if (this.match.contains("[")) {
                    stateName = (String)stateName + this.match.substring(this.match.indexOf("["));
                    class_2259.class_7211 result = this.parseState((String)stateName);
                    return this.matchesProperties(state, result.comp_623());
                }
                return true;
            }
            return false;
        }
        class_2259.class_7211 res = this.parseState(this.match);
        return res.comp_622().method_26204() == state.method_26204() && this.matchesProperties(state, res.comp_623());
    }

    public boolean matches(class_1297 entity) {
        String entityName = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
        if (this.wildcards) {
            String[] split = this.match.replace("*", ",").split(",");
            return StringHelper.matchesWildcards(entityName, split);
        }
        return entityName.equals(this.match);
    }

    public String getCondition() {
        return this.cond;
    }

    public boolean isFulfilled(class_3222 player) {
        return Services.GAMESTAGES.hasStage((class_1657)player, this.cond);
    }

    private class_2259.class_7211 parseState(String state) {
        try {
            class_2259.class_7211 result = class_2259.method_41957((class_7225)class_7923.field_41175, (String)state, (boolean)false);
            return result;
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean matchesProperties(class_2680 state, Map<class_2769<?>, Comparable<?>> props) {
        for (Map.Entry<class_2769<?>, Comparable<?>> entry : props.entrySet()) {
            Comparable val = state.method_11654(entry.getKey());
            if (val == entry.getValue()) continue;
            return false;
        }
        return true;
    }
}

