/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.events;

import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.*;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1269;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import tschipp.carryon.CarryOnCommon;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnData.CarryType;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.carry.PickupHandler;
import tschipp.carryon.common.carry.PlacementHandler;
import tschipp.carryon.common.scripting.ScriptReloadListener;
import tschipp.carryon.compat.ArchitecturyCompat;
import tschipp.carryon.config.ConfigLoader;
import tschipp.carryon.scripting.IdentifiableScriptReloadListener;

public class CommonEvents {

    public static void registerEvents() {

        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            if(!client)
                ConfigLoader.onConfigLoaded(registries);
        });

        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {

            if(world.method_8608())
                return class_1269.field_5811;

            class_2338 pos = hitResult.method_17777();
            class_2350 facing = hitResult.method_17780();

            CarryOnData carry = CarryOnDataManager.getCarryData(player);
            if(!carry.isCarrying())
            {
                if (PickupHandler.tryPickUpBlock((class_3222) player, pos, world, (pState, pPos) -> {
                    boolean success = PlayerBlockBreakEvents.BEFORE.invoker().beforeBlockBreak(world, player, pPos, pState, world.method_8321(pPos));
                    return success;
                }))
                    return class_1269.field_5812;
                return class_1269.field_5811;
            }
            else
            {
                if(carry.isCarrying(CarryOnData.CarryType.BLOCK))
                {
                    if(PlacementHandler.tryPlaceBlock((class_3222) player, pos, facing, (pState, pPos) -> {
                        return ArchitecturyCompat.sendPlaceEvent(world, pState, pPos, player);
                    }))
                        return class_1269.field_5812;
                }
                else
                {
                    if(PlacementHandler.tryPlaceEntity((class_3222) player, pos, facing, null))
                        return class_1269.field_5812;
                }

                //Fail here, so that we don't interact with placed things
                return class_1269.field_5814;
            }
        });




        UseEntityCallback.EVENT.register((player, level, hand, entity, hitResult) -> {

            if(level.method_8608())
                return class_1269.field_5811;

            CarryOnData carry = CarryOnDataManager.getCarryData(player);
            if (!carry.isCarrying()) {
                if (PickupHandler.tryPickupEntity((class_3222) player, entity, null)) {
                    return class_1269.field_5812;
                }
            }
            else if(carry.isCarrying(CarryOnData.CarryType.ENTITY) || carry.isCarrying(CarryType.PLAYER))
            {
                PlacementHandler.tryStackEntity((class_3222) player, entity);
            }

            return class_1269.field_5811;
        });


        CommandRegistrationCallback.EVENT.register(((dispatcher, registryAccess, environment) -> {
            CarryOnCommon.registerCommands(dispatcher);
        }));


        ResourceManagerHelper.get(class_3264.field_14190).registerReloadListener(new IdentifiableScriptReloadListener());


        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> {
            ScriptReloadListener.syncScriptsWithClient(player);
        });


        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for(class_3222 player : server.method_3760().method_14571())
                CarryOnCommon.onCarryTick(player);
        });

        ServerPlayerEvents.COPY_FROM.register(((oldPlayer, newPlayer, alive) -> {
            PlacementHandler.placeCarriedOnDeath(oldPlayer, newPlayer, !alive);
        }));

        PlayerBlockBreakEvents.BEFORE.register(((world, player, pos, state, blockEntity) -> {
            if(!CarryOnCommon.onTryBreakBlock(player))
                return false;
            return true;
        }));

        AttackBlockCallback.EVENT.register(((player, world, hand, pos, direction) -> {
            if(!CarryOnCommon.onTryBreakBlock(player))
                return class_1269.field_5812;
            return class_1269.field_5811;
        }));

        AttackEntityCallback.EVENT.register(((player, world, hand, entity, hitResult) -> {
            if(!CarryOnCommon.onAttackedByPlayer(player))
                return class_1269.field_5812;
            return class_1269.field_5811;
        }));

        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            CarryOnCommon.onRiderDisconnected(handler.method_32311());
        });

        ServerLivingEntityEvents.ALLOW_DEATH.register((entity, damageSource, damageAmount) -> {
            if(entity instanceof class_3222 sp) {
                CarryOnCommon.onRiderDisconnected(sp);
            }
            return true;
        });

        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            if(entity instanceof class_3222 sp) {
                CarryOnCommon.onPlayerAttacked(sp);
            }
            return true;
        });
    }

}
