/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.client.render;

import org.joml.Quaternionf;
import tschipp.carryon.Constants;
import tschipp.carryon.client.modeloverride.ModelOverride;
import tschipp.carryon.client.modeloverride.ModelOverrideHandler;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnData.CarryType;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.scripting.CarryOnScript;
import tschipp.carryon.common.scripting.CarryOnScript.ScriptRender;

import java.util.Optional;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_8942;

public class CarryRenderHelper
{
	public static class_243 getExactPos(class_1297 entity, float partialticks)
	{
		return new class_243(entity.field_6038 + (entity.method_23317() - entity.field_6038) * partialticks, entity.field_5971 + (entity.method_23318() - entity.field_5971) * partialticks, entity.field_5989 + (entity.method_23321() - entity.field_5989) * partialticks);
	}

	public static float getExactBodyRotationDegrees(class_1309 entity, float partialticks)
	{
		if (entity.method_5854() != null && entity.method_5854() instanceof class_1309 vehicle)
			if(vehicle instanceof class_1657 player)
				return -(player.field_6220 + (player.field_6283 - player.field_6220) * partialticks);
			else
				return -(entity.field_6259 + (entity.field_6241 - entity.field_6259) * partialticks);
		else
			return -(entity.field_6220 + (entity.field_6283 - entity.field_6220) * partialticks);
	}

	public static Quaternionf getExactBodyRotation(class_1309 entity, float partialticks)
	{
		return class_7833.field_40716.rotationDegrees(getExactBodyRotationDegrees(entity, partialticks));
	}

	public static void applyGeneralTransformations(class_1657 player, class_4587 matrix)
	{
		class_4050 pose = player.method_18376();

		matrix.method_22903();
		matrix.method_22905(0.6f, 0.6f, 0.6f);

		matrix.method_22904(0, 0, -1.35);

		if (doSneakCheck(player))
		{
			matrix.method_22904(0, -0.4, 0);
		}

		if (pose == class_4050.field_18079 || pose == class_4050.field_18077)
		{
			matrix.method_22904(0, 0, 2.5);
			matrix.method_22907(class_7833.field_40714.rotationDegrees(90));
		}

		matrix.method_22904(0, -0.5, 0.65);
	}

	public static class_4587 setupBlockTransformations(class_1657 player, class_4587 matrix, CarryOnData carry, boolean firstPerson) {
		if (firstPerson) {
			matrix.method_22905(2.5f, 2.5f, 2.5f);
			matrix.method_22904(0, -0.5, -1);

			if (Constants.CLIENT_CONFIG.facePlayer != CarryRenderHelper.isChest(carry.getBlock().method_26204())) {
				matrix.method_22907(class_7833.field_40716.rotationDegrees(180));
				matrix.method_22907(class_7833.field_40713.rotationDegrees(8));
			} else {
				matrix.method_22907(class_7833.field_40714.rotationDegrees(8));
			}
			carry.getActiveScript().ifPresent(script -> CarryRenderHelper.performScriptTransformation(matrix, script));

			return matrix;
		} else {
			CarryRenderHelper.applyBlockTransformations(player, matrix, carry.getBlock().method_26204());
			carry.getActiveScript().ifPresent(script -> CarryRenderHelper.performScriptTransformation(matrix, script));

			class_4587.class_4665 p = matrix.method_23760();
			class_4587 copy = new class_4587();
			copy.method_34425(p.method_23761());
			matrix.method_22909();

			return copy;
		}
	}

	public static void applyBlockTransformations(class_1657 player, class_4587 matrix, class_2248 block)
	{
		matrix.method_22907(class_7833.field_40717.rotationDegrees(180));
		applyGeneralTransformations(player, matrix);

		if (Constants.CLIENT_CONFIG.facePlayer != CarryRenderHelper.isChest(block))
		{
			//TODO: RealFirstPersonRender
			//if ((ModList.get().isLoaded("realrender") || ModList.get().isLoaded("rfpr")) && perspective == 0)
			//	matrix.translate(0, 0, -0.4);
			matrix.method_22907(class_7833.field_40716.rotationDegrees(180));
		}

		float height = getRenderHeight(player);
		float offset = (height - 1f) / 1.2f;
		matrix.method_46416(0, -offset, 0);
	}

	public static void setupEntityTransformations(class_1657 player, class_4587 matrix, CarryOnData carry, boolean firstPerson) {

		class_1297 entity = carry.getEntity(player.method_73183());

		float height = entity.method_17682();
		float width = entity.method_17681();

		if(firstPerson) {
			matrix.method_22907(class_7833.field_40716.rotationDegrees(180));

			matrix.method_22905(0.8f, 0.8f, 0.8f);
			matrix.method_22904(0.0, -height - .2, width * 1.3 + 0.1);

			carry.getActiveScript().ifPresent(script -> CarryRenderHelper.performScriptTransformation(matrix, script));

			if(Constants.CLIENT_CONFIG.rotateEntitiesSideways)
				matrix.method_22907(class_7833.field_40716.rotationDegrees(90));
		}
		else {
			applyEntityTransformations(player, matrix, entity);

			carry.getActiveScript().ifPresent(script -> CarryRenderHelper.performScriptTransformation(matrix, script));
		}
	}

	public static void applyEntityTransformations(class_1657 player, class_4587 matrix, class_1297 entity)
	{
		class_4050 pose = player.method_18376();

		applyGeneralTransformations(player, matrix);

		matrix.method_22907(class_7833.field_40714.rotationDegrees(180));

		matrix.method_22904(0, -3.1, -0.65);
		matrix.method_22905(1.666f, 1.666f, 1.666f);

		float height = entity.method_17682();
		float width = entity.method_17681();
		float multiplier = Math.min(9.9f, height * width) ;
		entity.field_6036 = 0.0f;
		entity.field_5982 = 0.0f;
		entity.method_5847(0.0f);
		entity.field_6014 = 0.0f;
		entity.field_6004 = 0.0f;

		matrix.method_22905((10 - multiplier) * 0.08f, (10 - multiplier) * 0.08f, (10 - multiplier) * 0.08f);
		matrix.method_22904(0.0, height / 2 + -(height / 4) + 1, width - 0.1 < 0.7 ? width - 0.1 + (0.7 - (width - 0.1)) : width - 0.1);

		if(doSneakCheck(player))
			matrix.method_22904(0, -0.4, 0);

		if (pose == class_4050.field_18079 || pose == class_4050.field_18077)
		{
			matrix.method_22907(class_7833.field_40713.rotationDegrees(180));
			matrix.method_22904(0, 0.2 * height - 2, -0.5);
		}

		if(Constants.CLIENT_CONFIG.rotateEntitiesSideways)
			matrix.method_22907(class_7833.field_40716.rotationDegrees(90));

	}


	public static void performScriptTransformation(class_4587 matrix, CarryOnScript script)
	{
		int perspective = getPerspective();

		ScriptRender render = script.scriptRender();

		class_243 translation = render.renderTranslation().getVec();
		class_243 rotation = render.renderRotation().getVec();
		class_243 scale = render.renderscale().getVec(1, 1, 1);

		Quaternionf rot = class_7833.field_40714.rotationDegrees((float) rotation.field_1352);
		rot.mul(class_7833.field_40716.rotationDegrees((float) rotation.field_1351));
		rot.mul(class_7833.field_40718.rotationDegrees((float) rotation.field_1350));
		matrix.method_22907(rot);

		matrix.method_22904(translation.field_1352, translation.field_1351, perspective == 1 && script.isBlock() ? -translation.field_1350 : translation.field_1350);

		matrix.method_22905((float) scale.field_1352, (float) scale.field_1351, (float) scale.field_1350);
	}

	/*
	@Deprecated
	public static void renderBakedModel(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, BakedModel model)
	{
		ItemStackRenderState state = new ItemStackRenderState();

		try {


			ItemStackRenderState.LayerRenderState layer = state.newLayer();
			if(stack.hasFoil())
				layer.setFoilType(ItemStackRenderState.FoilType.STANDARD);
			layer.setupBlockModel(model, RenderType.translucent());

			state.render(matrix, buffer, light, OverlayTexture.NO_OVERLAY);


			ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
			renderer.renderStatic(stack, ItemDisplayContext.NONE, light, OverlayTexture.NO_OVERLAY, matrix, buffer, null, model, 0);
			renderer.render(stack, ItemDisplayContext.NONE, false, matrix, buffer, light, OverlayTexture.NO_OVERLAY, model);

		}
		catch (Exception e)
		{
		}
	}
	*/

	public static class_1799 getRenderItemStack(class_1657 player)
	{
		CarryOnData carry = CarryOnDataManager.getCarryData(player);
		class_2680 state = carry.getBlock().method_26204().method_9564();
		if(carry.getActiveScript().isPresent())
		{
			ScriptRender render = carry.getActiveScript().get().scriptRender();
			if(render.renderNameBlock().isPresent())
			{
				state = class_7923.field_41175.method_46746(render.renderNameBlock().get()).get().comp_349().method_9564();
			}
		}

		class_1799 renderStack = class_1799.field_8037;

		Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
		if(ov.isPresent())
		{
			var renderObj = ov.get().getRenderObject();
			if(renderObj.right().isPresent())
				state = renderObj.right().get();
			else if (renderObj.left().isPresent())
				renderStack = renderObj.left().get();
		}

		if(renderStack.method_7960())
			renderStack = new class_1799(state.method_26204());

		return renderStack;
	}

	public static class_2680 getRenderState(class_1657 player)
	{
		CarryOnData carry = CarryOnDataManager.getCarryData(player);
		class_2680 state = carry.getBlock().method_26204().method_9564();
		if(carry.getActiveScript().isPresent())
		{
			ScriptRender render = carry.getActiveScript().get().scriptRender();
			if(render.renderNameBlock().isPresent())
			{
				state = class_7923.field_41175.method_46746(render.renderNameBlock().get()).get().comp_349().method_9564();
			}
		}

		Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
		if(ov.isPresent())
		{
			var renderObj = ov.get().getRenderObject();
			if(renderObj.right().isPresent())
				state = renderObj.right().get();
		}

		return state;
	}


	/*
	@Deprecated
	public static BakedModel getRenderBlock(Player player)
	{
		CarryOnData carry = CarryOnDataManager.getCarryData(player);
		ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
		Minecraft.getInstance().getModelManager().specialBlockModelRenderer().get().
		BlockState state = getRenderState(player);
		BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);

		if(state.getRenderShape() != RenderShape.MODEL || model.isCustomRenderer() || model.getQuads(state, null, RandomSource.create()).size() <= 0) {
			ItemStack stack = new ItemStack(state.getBlock());
			model = renderer.getModel(stack, player.level(), player, 0);
		}

		Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
		if(ov.isPresent())
		{
			var renderObj = ov.get().getRenderObject();
			if(renderObj.left().isPresent())
				model = renderer.getModel(renderObj.left().get(), player.level(), player, 0);
		}

		return model;
	}
	 */

	public static class_1297 getRenderEntity(class_1657 player)
	{
		CarryOnData carry = CarryOnDataManager.getCarryData(player);
		class_1297 entity = carry.getEntity(player.method_73183());

		if(carry.getActiveScript().isPresent())
		{
			CarryOnScript script = carry.getActiveScript().get();
			ScriptRender render = script.scriptRender();
			if(render.renderNameEntity().isPresent())
				entity = class_7923.field_41177.method_46746(render.renderNameEntity().get()).get().comp_349().method_5883(player.method_73183(), class_3730.field_16467);

			if(render.renderNBT().isPresent()) {
				class_11368 input = class_11352.method_71417(new class_8942.class_11340(Constants.LOG), player.method_56673(), render.renderNBT().get());
				entity.method_5651(input);
			}
		}

		return entity;
	}

	public static float getRenderWidth(class_1657 player)
	{
		CarryOnData carry = CarryOnDataManager.getCarryData(player);
		if(carry.isCarrying(CarryType.BLOCK))
		{
			class_2680 state = getRenderState(player);
			class_265 shape = state.method_26218(player.method_73183(), player.method_24515());
			if(shape == null || shape.method_1110())
				return 1f;
			Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
			if(ov.isPresent())
			{
				var renderObj = ov.get().getRenderObject();
				if(renderObj.left().isPresent())
					return 0.8f;
			}
			float width = (float)Math.abs(shape.method_1107().field_1320 - shape.method_1107().field_1323);
			return width;
		}
		else if(carry.isCarrying(CarryType.ENTITY))
		{
			class_1297 entity = getRenderEntity(player);
			float w =  entity.method_17681();
			if (Constants.CLIENT_CONFIG.rotateEntitiesSideways)
				return w - (w*w) * 0.35f;
			return w * 0.9f;
		}
		else
			return 1f;
	}

	public static float getRenderHeight(class_1657 player)
	{
		CarryOnData carry = CarryOnDataManager.getCarryData(player);
		if(carry.isCarrying(CarryType.BLOCK))
		{
			class_2680 state = getRenderState(player);
			class_265 shape = state.method_26218(player.method_73183(), player.method_24515());
			if(shape == null || shape.method_1110())
				return 1f;
			Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
			if(ov.isPresent())
			{
				var renderObj = ov.get().getRenderObject();
				if(renderObj.left().isPresent())
					return 0.5f;
			}
			float height = (float)Math.abs(shape.method_1107().field_1325 - shape.method_1107().field_1322);
			return height;
		}
		else if(carry.isCarrying(CarryType.ENTITY))
		{
			class_1297 entity = getRenderEntity(player);
			return entity.method_17682();
		}
		else
			return 1f;
	}


	@SuppressWarnings("resource")
	public static int getPerspective()
	{
		boolean isThirdPerson = !class_310.method_1551().field_1690.method_31044().method_31034(); // isThirdPerson
		boolean isThirdPersonReverse = class_310.method_1551().field_1690.method_31044().method_31035();

		if (!isThirdPerson && !isThirdPersonReverse)
			return 0;
		if (isThirdPerson && !isThirdPersonReverse)
			return 1;
		return 2;
	}

	public static boolean doSneakCheck(class_1657 player)
	{
		if (player.method_31549().field_7479)
			return false;

		return player.method_5715() || player.method_18276();
	}

	public static boolean isChest(class_2248 block)
	{
		return block == class_2246.field_10034 || block == class_2246.field_10443 || block == class_2246.field_10380 || block instanceof class_2281;
	}

}
