/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.networking.serverbound;

import net.minecraft.class_1657;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.networking.PacketBase;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingPacket;
import tschipp.carryon.networking.clientbound.ClientboundSyncScriptsPacket;

public record ServerboundCarryKeyPressedPacket(boolean pressed) implements PacketBase
{
	public static final class_9139<class_9129, ServerboundCarryKeyPressedPacket> CODEC = class_9139.method_56434(
			class_9135.field_48547, ServerboundCarryKeyPressedPacket::pressed,
			ServerboundCarryKeyPressedPacket::new
	);

	public static final class_8710.class_9154<ServerboundCarryKeyPressedPacket> TYPE = new class_9154<>(Constants.PACKET_ID_KEY_PRESSED);

	@Override
	public void handle(class_1657 player)
	{
		CarryOnData carry = CarryOnDataManager.getCarryData(player);
		carry.setKeyPressed(this.pressed);
		CarryOnDataManager.setCarryData(player, carry);
	}

	@Override
	public class_9154<ServerboundCarryKeyPressedPacket> method_56479() {
		return TYPE;
	}
}
