/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.mixin;


import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;

@Mixin(class_1657.class)
public abstract class PlayerMixin extends class_1309 implements CarryOnDataManager.ICarrying {

    @Unique
    private static final class_2940<class_2487> CARRY_DATA_KEY = class_2945.method_12791(class_1657.class, class_2943.field_13318);

    @Override
    public void setCarryOnData(CarryOnData data)
    {
        data.setSelected(this.getInventory().field_7545);
        class_2487 nbt = data.getNbt();
        nbt.method_10569("tick", field_6012);
        this.method_5841().method_12778(CARRY_DATA_KEY, nbt);
    }

    @Override
    public CarryOnData getCarryOnData()
    {
        class_2487 data = this.method_5841().method_12789(CARRY_DATA_KEY);
        return new CarryOnData(data.method_10553());
    }

    @Shadow
    public abstract class_1661 getInventory();


    private PlayerMixin(class_1299<? extends class_1309> type, class_1937 level) {
        super(type, level);
    }


    @Inject(method = "defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V", at = @At("RETURN"))
    private void onDefineSynchedData(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(CARRY_DATA_KEY, new class_2487());
    }


    @Inject(method = "addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", at = @At("RETURN"))
    private void onAddAdditionalSaveData(class_2487 tag, CallbackInfo info)
    {
        CarryOnData carry = CarryOnDataManager.getCarryData((class_1657)(Object)this);
        tag.method_10566("CarryOnData", carry.getNbt());
    }

    @Inject(method = "readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", at = @At("RETURN"))
    private void onReadAdditionalSaveData(class_2487 tag, CallbackInfo info)
    {
        if (tag.method_10545("CarryOnData")) {
            CarryOnData data = new CarryOnData(tag.method_10562("CarryOnData"));
            setCarryOnData(data);
        }
    }

}
