/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.common.scripting;

import tschipp.carryon.Constants;
import tschipp.carryon.common.scripting.CarryOnScript.ScriptObject.ScriptObjectBlock;
import tschipp.carryon.common.scripting.CarryOnScript.ScriptObject.ScriptObjectEntity;

import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_7923;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ScriptManager
{
	public static final List<CarryOnScript> SCRIPTS = new ArrayList<>();

	public static Optional<CarryOnScript> inspectBlock(class_2680 state, class_1937 level, class_2338 pos, @Nullable class_2487 tag)
	{
		if (!Constants.COMMON_CONFIG.settings.useScripts)
			return Optional.empty();

		class_2248 block = state.method_26204();
		float hardness = state.method_26214(level, pos);
		float resistance = block.method_9520();

		for (CarryOnScript script : SCRIPTS)
		{
			if (script.isBlock() && matchesAll(script, block, hardness, resistance, tag))
				return Optional.of(script);
		}

		return Optional.empty();
	}

	public static Optional<CarryOnScript> inspectEntity(class_1297 entity)
	{
		if (!Constants.COMMON_CONFIG.settings.useScripts)
			return Optional.empty();

		float height = entity.method_17682();
		float width = entity.method_17681();
		float health = entity instanceof class_1309 ? ((class_1309) entity).method_6032() : 0.0f;
		class_2487 tag = new class_2487();
		entity.method_5662(tag);

		for (CarryOnScript script : SCRIPTS)
		{
			if (script.isEntity() && matchesAll(script, entity, height, width, health, tag))
				return Optional.of(script);
		}

		return Optional.empty();
	}

	private static boolean matchesAll(CarryOnScript script, class_1297 entity, float height, float width, float health, class_2487 tag)
	{
		ScriptObjectEntity scEntity = script.scriptObject().entity();

		boolean matchname = true;
		if(scEntity.typeNameEntity().isPresent())
			matchname = entity.method_5864().equals(class_7923.field_41177.method_29107(scEntity.typeNameEntity().get()));
		boolean matchheight = scEntity.typeHeight().matches(height);
		boolean matchwidth = scEntity.typeWidth().matches(width);
		boolean matchhealth = scEntity.typeHealth().matches(health);
		boolean matchnbt = scEntity.typeEntityTag().matches(tag);

		return matchname && matchheight && matchwidth && matchhealth && matchnbt;
	}

	private static boolean matchesAll(CarryOnScript script, class_2248 block, float hardness, float resistance, class_2487 nbt)
	{
		ScriptObjectBlock scBlock = script.scriptObject().block();

		boolean matchblock = true;
		if(scBlock.typeNameBlock().isPresent())
			matchblock = block == class_7923.field_41175.method_29107(scBlock.typeNameBlock().get());
		boolean matchnbt = scBlock.typeBlockTag().matches(nbt);
		boolean matchhardness = scBlock.typeHardness().matches(hardness);
		boolean matchresistance = scBlock.typeResistance().matches(resistance);

		return matchnbt && matchblock && matchhardness && matchresistance;
	}
}
