/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.client.render;

import org.joml.Quaternionf;
import tschipp.carryon.Constants;
import tschipp.carryon.client.modeloverride.ModelOverride;
import tschipp.carryon.client.modeloverride.ModelOverrideHandler;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnData.CarryType;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.scripting.CarryOnScript;
import tschipp.carryon.common.scripting.CarryOnScript.ScriptRender;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_918;

public class CarryRenderHelper
{
	public static class_243 getExactPos(class_1297 entity, float partialticks)
	{
		return new class_243(entity.field_6038 + (entity.method_23317() - entity.field_6038) * partialticks, entity.field_5971 + (entity.method_23318() - entity.field_5971) * partialticks, entity.field_5989 + (entity.method_23321() - entity.field_5989) * partialticks);
	}

	public static float getExactBodyRotationDegrees(class_1309 entity, float partialticks)
	{
		if (entity.method_5854() != null && entity.method_5854() instanceof class_1309 vehicle)
			if(vehicle instanceof class_1657 player)
				return -(player.field_6220 + (player.field_6283 - player.field_6220) * partialticks);
			else
				return -(entity.field_6259 + (entity.field_6241 - entity.field_6259) * partialticks);
		else
			return -(entity.field_6220 + (entity.field_6283 - entity.field_6220) * partialticks);
	}

	public static Quaternionf getExactBodyRotation(class_1309 entity, float partialticks)
	{
		return class_7833.field_40716.rotationDegrees(getExactBodyRotationDegrees(entity, partialticks));
	}

	public static void applyGeneralTransformations(class_1657 player, float partialticks, class_4587 matrix)
	{
		int perspective = CarryRenderHelper.getPerspective();
		Quaternionf playerrot = CarryRenderHelper.getExactBodyRotation(player, partialticks);
		class_243 playerpos = CarryRenderHelper.getExactPos(player, partialticks);
		class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
		class_243 offset = playerpos.method_1020(cameraPos);
		class_4050 pose = player.method_18376();

		matrix.method_22903();
		matrix.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);

		if (perspective == 2)
			playerrot.mul(class_7833.field_40716.rotationDegrees(180));
		matrix.method_22907(playerrot);

		matrix.method_22903();
		matrix.method_22905(0.6f, 0.6f, 0.6f);

		if (perspective == 2)
			matrix.method_22904(0, 0, -1.35);

		if (doSneakCheck(player))
		{
			matrix.method_22904(0, -0.4, 0);
		}

		if (pose == class_4050.field_18079)
		{
			float f = player.method_6024(partialticks);
			float f3 = player.method_5799() ? -90.0F - player.field_6004 : -90.0F;
			float f4 = class_3532.method_16439(f, 0.0F, f3);
			if (perspective == 2)
			{
				matrix.method_22904(0, 0, 1.35);
				matrix.method_22907(class_7833.field_40714.rotationDegrees(f4));
			}
			else
				matrix.method_22907(class_7833.field_40713.rotationDegrees(f4));

			matrix.method_22904(0, -1.5, -1.848);
			if (perspective == 2)
				matrix.method_22904(0, 0, 2.38);
		}

		if (pose == class_4050.field_18077)
		{
			float f1 = player.method_6003() + partialticks;
			float f2 = class_3532.method_15363(f1 * f1 / 100.0F, 0.0F, 1.0F);
			if (!player.method_6123())
			{
				if (perspective == 2)
					matrix.method_22904(0, 0, 1.35);

				if (perspective == 2)
					matrix.method_22907(class_7833.field_40714.rotationDegrees(f2 * (-90.0F - player.field_6004)));
				else
					matrix.method_22907(class_7833.field_40713.rotationDegrees(f2 * (-90.0F - player.field_6004)));
			}

			class_243 viewVector = player.method_5828(partialticks);
			class_243 deltaMovement = player.method_18798();
			double d0 = deltaMovement.method_37268();
			double d1 = deltaMovement.method_37268();
			if (d0 > 0.0D && d1 > 0.0D)
			{
				double d2 = (deltaMovement.field_1352 * viewVector.field_1352 + deltaMovement.field_1350 * viewVector.field_1350) / (Math.sqrt(d0) * Math.sqrt(d1));
				double d3 = deltaMovement.field_1352 * viewVector.field_1350 - deltaMovement.field_1350 * viewVector.field_1352;

				matrix.method_22907(class_7833.field_40716.rotation((float) (Math.signum(d3) * Math.acos(d2))));
			}

			if (perspective != 2)
				matrix.method_22904(0, 0, -1.35);
			matrix.method_22904(0, -0.2, 0);
		}

		matrix.method_22904(0, 1.6, 0.65);
	}

	public static void applyBlockTransformations(class_1657 player, float partialticks, class_4587 matrix, class_2248 block)
	{
		int perspective = CarryRenderHelper.getPerspective();

		applyGeneralTransformations(player, partialticks, matrix);

		if (Constants.CLIENT_CONFIG.facePlayer != CarryRenderHelper.isChest(block))
		{
			//TODO: RealFirstPersonRender
			//if ((ModList.get().isLoaded("realrender") || ModList.get().isLoaded("rfpr")) && perspective == 0)
			//	matrix.translate(0, 0, -0.4);
			matrix.method_22907(class_7833.field_40716.rotationDegrees(180));
		}
//		if(perspective == 1)
//		{
//			matrix.pushPose();
//			//matrix.mulPose(Axis.YP.rotationDegrees(180));
//			matrix.popPose();
//		}

		//else if ((ModList.get().isLoaded("realrender") || ModList.get().isLoaded("rfpr")) && perspective == 0)
		//	matrix.translate(0, 0, 0.4);
		//matrix.mulPose(Axis.YP.rotationDegrees(180));



		float height = getRenderHeight(player);
		float offset = (height - 1f) / 1.2f;
		matrix.method_46416(0, -offset, 0);
	}

	public static void applyEntityTransformations(class_1657 player, float partialticks, class_4587 matrix, class_1297 entity)
	{
		int perspective = CarryRenderHelper.getPerspective();
		class_4050 pose = player.method_18376();

		applyGeneralTransformations(player, partialticks, matrix);

		if (perspective == 2)
			matrix.method_22904(0, -1.6, 0.65);
		else
			matrix.method_22904(0, -1.6, -0.65);
		matrix.method_22905(1.666f, 1.666f, 1.666f);

		float height = entity.method_17682();
		float width = entity.method_17681();
		float multiplier = height * width;
		entity.field_6036 = 0.0f;
		entity.field_5982 = 0.0f;
		entity.method_5847(0.0f);
		entity.field_6014 = 0.0f;
		entity.field_6004 = 0.0f;

		if (perspective == 2)
			matrix.method_22907(class_7833.field_40716.rotationDegrees(180));

		matrix.method_22905((10 - multiplier) * 0.08f, (10 - multiplier) * 0.08f, (10 - multiplier) * 0.08f);
		matrix.method_22904(0.0, height / 2 + -(height / 2) + 1, width - 0.1 < 0.7 ? width - 0.1 + (0.7 - (width - 0.1)) : width - 0.1);

		if (pose == class_4050.field_18079 || pose == class_4050.field_18077)
		{
			matrix.method_22907(class_7833.field_40713.rotationDegrees(90));
			matrix.method_22904(0, -0.2 * height, 0);

			if (pose == class_4050.field_18077)
				matrix.method_22904(0, 0, 0.2);
		}

	}


	public static void performScriptTransformation(class_4587 matrix, CarryOnScript script)
	{
		int perspective = getPerspective();

		ScriptRender render = script.scriptRender();

		class_243 translation = render.renderTranslation().getVec();
		class_243 rotation = render.renderRotation().getVec();
		class_243 scale = render.renderscale().getVec(1, 1, 1);

		Quaternionf rot = class_7833.field_40714.rotationDegrees((float) rotation.field_1352);
		rot.mul(class_7833.field_40716.rotationDegrees((float) rotation.field_1351));
		rot.mul(class_7833.field_40718.rotationDegrees((float) rotation.field_1350));
		matrix.method_22907(rot);

		matrix.method_22904(translation.field_1352, translation.field_1351, perspective == 1 && script.isBlock() ? -translation.field_1350 : translation.field_1350);

		matrix.method_22905((float) scale.field_1352, (float) scale.field_1351, (float) scale.field_1350);
	}



	public static void renderBakedModel(class_1799 stack, class_4587 matrix, class_4597 buffer, int light, class_1087 model)
	{
		try {
			class_918 renderer = class_310.method_1551().method_1480();
			renderer.method_23179(stack, class_811.field_4315, false, matrix, buffer, light, class_4608.field_21444, model);
		}
		catch (Exception e)
		{
		}
	}

	public static class_2680 getRenderState(class_1657 player)
	{
		CarryOnData carry = CarryOnDataManager.getCarryData(player);
		class_2680 state = carry.getBlock().method_26204().method_9564();
		if(carry.getActiveScript().isPresent())
		{
			ScriptRender render = carry.getActiveScript().get().scriptRender();
			if(render.renderNameBlock().isPresent())
			{
				state = class_7923.field_41175.method_29107(render.renderNameBlock().get()).method_9564();
			}
		}

		Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
		if(ov.isPresent())
		{
			var renderObj = ov.get().getRenderObject();
			if(renderObj.right().isPresent())
				state = renderObj.right().get();
		}

		return state;
	}

	public static class_1087 getRenderBlock(class_1657 player)
	{
		CarryOnData carry = CarryOnDataManager.getCarryData(player);
		class_918 renderer = class_310.method_1551().method_1480();
		class_2680 state = getRenderState(player);
		class_1087 model = class_310.method_1551().method_1541().method_3349(state);

		if(state.method_26217() != class_2464.field_11458 || model.method_4713() || model.method_4707(state, null, class_5819.method_43047()).size() <= 0) {
			class_1799 stack = new class_1799(state.method_26204());
			model = renderer.method_4019(stack, player.method_37908(), player, 0);
		}

		Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
		if(ov.isPresent())
		{
			var renderObj = ov.get().getRenderObject();
			if(renderObj.left().isPresent())
				model = renderer.method_4019(renderObj.left().get(), player.method_37908(), player, 0);
		}

		return model;
	}

	public static class_1297 getRenderEntity(class_1657 player)
	{
		CarryOnData carry = CarryOnDataManager.getCarryData(player);
		class_1297 entity = carry.getEntity(player.method_37908());

		if(carry.getActiveScript().isPresent())
		{
			CarryOnScript script = carry.getActiveScript().get();
			ScriptRender render = script.scriptRender();
			if(render.renderNameEntity().isPresent())
				entity = class_7923.field_41177.method_29107(render.renderNameEntity().get()).method_5883(player.method_37908());

			if(render.renderNBT().isPresent())
				entity.method_5651(render.renderNBT().get());
		}

		return entity;
	}

	public static float getRenderWidth(class_1657 player)
	{
		CarryOnData carry = CarryOnDataManager.getCarryData(player);
		if(carry.isCarrying(CarryType.BLOCK))
		{
			class_2680 state = getRenderState(player);
			class_265 shape = state.method_26218(player.method_37908(), player.method_24515());
			if(shape == null || shape.method_1110())
				return 1f;
			Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
			if(ov.isPresent())
			{
				var renderObj = ov.get().getRenderObject();
				if(renderObj.left().isPresent())
					return 0.8f;
			}
			float width = (float)Math.abs(shape.method_1107().field_1320 - shape.method_1107().field_1323);
			return width;
		}
		else if(carry.isCarrying(CarryType.ENTITY))
		{
			class_1297 entity = getRenderEntity(player);
			return entity.method_17681();
		}
		else
			return 1f;
	}

	public static float getRenderHeight(class_1657 player)
	{
		CarryOnData carry = CarryOnDataManager.getCarryData(player);
		if(carry.isCarrying(CarryType.BLOCK))
		{
			class_2680 state = getRenderState(player);
			class_265 shape = state.method_26218(player.method_37908(), player.method_24515());
			if(shape == null || shape.method_1110())
				return 1f;
			Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
			if(ov.isPresent())
			{
				var renderObj = ov.get().getRenderObject();
				if(renderObj.left().isPresent())
					return 0.5f;
			}
			float height = (float)Math.abs(shape.method_1107().field_1325 - shape.method_1107().field_1322);
			return height;
		}
		else if(carry.isCarrying(CarryType.ENTITY))
		{
			class_1297 entity = getRenderEntity(player);
			return entity.method_17682();
		}
		else
			return 1f;
	}


	@SuppressWarnings("resource")
	public static int getPerspective()
	{
		boolean isThirdPerson = !class_310.method_1551().field_1690.method_31044().method_31034(); // isThirdPerson
		boolean isThirdPersonReverse = class_310.method_1551().field_1690.method_31044().method_31035();

		if (!isThirdPerson && !isThirdPersonReverse)
			return 0;
		if (isThirdPerson && !isThirdPersonReverse)
			return 1;
		return 2;
	}

	public static boolean doSneakCheck(class_1657 player)
	{
		if (player.method_31549().field_7479)
			return false;

		return player.method_5715() || player.method_18276();
	}

	public static boolean isChest(class_2248 block)
	{
		return block == class_2246.field_10034 || block == class_2246.field_10443 || block == class_2246.field_10380;
	}

}
