/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import org.joml.Matrix4f;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnData.CarryType;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.scripting.CarryOnScript;
import tschipp.carryon.common.scripting.CarryOnScript.ScriptRender;
import tschipp.carryon.platform.Services;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedMap;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4597.class_4598;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import net.minecraft.class_9799;

public class CarriedObjectRender
{

	private static SequencedMap<class_1921, class_9799> builders = new LinkedHashMap<>(Map.of(
			class_1921.method_23590(), new class_9799(class_1921.method_23590().method_22722()),
			class_1921.method_27949(), new class_9799(class_1921.method_27949().method_22722()),
			class_1921.method_30676(), new class_9799(class_1921.method_30676().method_22722()),
			class_1921.method_23591(), new class_9799(class_1921.method_23591().method_22722()),
			class_1921.method_29707(), new class_9799(class_1921.method_29707().method_22722())
	));

	public static boolean drawFirstPerson(class_1657 player, class_4597 buffer, class_4587 matrix, int light, float partialTicks)
	{
		if(Services.PLATFORM.isModLoaded("firstperson") || Services.PLATFORM.isModLoaded("firstpersonmod"))
			return false;

		CarryOnData carry = CarryOnDataManager.getCarryData(player);
		try {
			if (carry.isCarrying(CarryType.BLOCK))
				drawFirstPersonBlock(player, buffer, matrix, light, CarryRenderHelper.getRenderState(player));
			else if (carry.isCarrying(CarryType.ENTITY))
				drawFirstPersonEntity(player, buffer, matrix, light, partialTicks);
		}
		catch (Exception e)
		{
			//hehe
		}

		if(carry.getActiveScript().isPresent())
		{
			ScriptRender render = carry.getActiveScript().get().scriptRender();
			if(!render.renderLeftArm() && player.method_6068() == class_1306.field_6182)
				return false;

			if(!render.renderRightArm() && player.method_6068() == class_1306.field_6183)
				return false;
		}

		return carry.isCarrying();
	}

	private static void drawFirstPersonBlock(class_1657 player, class_4597 buffer, class_4587 matrix, int light, class_2680 state)
	{
		matrix.method_22903();
		matrix.method_22905(2.5f, 2.5f, 2.5f);
		matrix.method_22904(0, -0.5, -1);
		RenderSystem.enableBlend();
		RenderSystem.disableCull();

		CarryOnData carry = CarryOnDataManager.getCarryData(player);

		if (Constants.CLIENT_CONFIG.facePlayer != CarryRenderHelper.isChest(state.method_26204())) {
			matrix.method_22907(class_7833.field_40716.rotationDegrees(180));
			matrix.method_22907(class_7833.field_40713.rotationDegrees(8));
		} else {
			matrix.method_22907(class_7833.field_40714.rotationDegrees(8));
		}

		if(carry.getActiveScript().isPresent())
			CarryRenderHelper.performScriptTransformation(matrix, carry.getActiveScript().get());

		RenderSystem.setShaderTexture(0, class_1723.field_21668);

		class_1799 stack = new class_1799(state.method_26204().method_8389());
		class_1087 model = CarryRenderHelper.getRenderBlock(player);
		CarryRenderHelper.renderBakedModel(stack, matrix, buffer, light, model);

		RenderSystem.enableCull();
		RenderSystem.disableBlend();
		matrix.method_22909();
	}

	private static void drawFirstPersonEntity(class_1657 player, class_4597 buffer, class_4587 matrix, int light, float partialTicks) {
		class_898 manager = class_310.method_1551().method_1561();
		class_1297 entity = CarryRenderHelper.getRenderEntity(player);
		CarryOnData carry = CarryOnDataManager.getCarryData(player);

		if (entity != null)
		{
			class_243 playerpos = CarryRenderHelper.getExactPos(player, partialTicks);

			entity.method_5814(playerpos.field_1352, playerpos.field_1351, playerpos.field_1350);
			entity.field_6004 = 0.0f;
			entity.field_5982 = 0.0f;
			entity.method_5847(0.0f);

			float height = entity.method_17682();
			float width = entity.method_17681();

			matrix.method_22903();
			matrix.method_22905(0.8f, 0.8f, 0.8f);
			matrix.method_22907(class_7833.field_40716.rotationDegrees(180));
			matrix.method_22904(0.0, -height - .1, width + 0.1);

			manager.method_3948(false);

			Optional<CarryOnScript> res = carry.getActiveScript();
			if(res.isPresent())
			{
				CarryOnScript script = res.get();
				CarryRenderHelper.performScriptTransformation(matrix, script);
			}

			if (entity instanceof class_1309)
				((class_1309) entity).field_6235 = 0;

			try {
				manager.method_3954(entity, 0, 0, 0, 0f, 0, matrix, buffer, light);
			}
			catch (Exception e)
			{
			}
			manager.method_3948(true);
			matrix.method_22909();

		}

		// RenderSystem.disableAlphaTest();
	}

	/**
	 * Draws the third person view of entities and blocks
	 * @param partialticks
	 * @param mat
	 */
	public static void drawThirdPerson(float partialticks, Matrix4f mat) {
		class_310 mc = class_310.method_1551();
		class_1937 level = mc.field_1687;
		int light = 0;
		int perspective = CarryRenderHelper.getPerspective();
		class_898 manager = mc.method_1561();

		class_4587 matrix = new class_4587();
		matrix.method_34425(mat);

		RenderSystem.enableBlend();
		RenderSystem.disableCull();
		RenderSystem.disableDepthTest();

		class_4598 buffer = class_4597.method_22992(builders, builders.get(class_1921.method_23590()));

		for (class_1657 player : level.method_18456())
		{
			try {

				CarryOnData carry = CarryOnDataManager.getCarryData(player);

				if (perspective == 0 && player == mc.field_1724 && !(Services.PLATFORM.isModLoaded("firstperson") || Services.PLATFORM.isModLoaded("firstpersonmod") || Services.PLATFORM.isModLoaded("realcamera")))
					continue;

				light = manager.method_23839(player, partialticks);

				if (carry.isCarrying(CarryType.BLOCK)) {
					class_2680 state = CarryRenderHelper.getRenderState(player);

					CarryRenderHelper.applyBlockTransformations(player, partialticks, matrix, state.method_26204());

					class_1799 tileItem = new class_1799(state.method_26204().method_8389());
					class_1087 model = CarryRenderHelper.getRenderBlock(player);

					//ModelOverridesHandler.hasCustomOverrideModel(state, tag) ? ModelOverridesHandler.getCustomOverrideModel(state, tag, level, player) : tileItem.isEmpty() ? mc.getBlockRenderer().getBlockModel(state) : mc.getItemRenderer().getModel(tileItem, level, player, 0);
//
					Optional<CarryOnScript> res = carry.getActiveScript();
					if (res.isPresent()) {
						CarryOnScript script = res.get();
						CarryRenderHelper.performScriptTransformation(matrix, script);
					}

					RenderSystem.setShaderTexture(0, class_1723.field_21668);
					RenderSystem.enableCull();

					class_4587.class_4665 p = matrix.method_23760();
					class_4587 copy = new class_4587();
					copy.method_34425(p.method_23761());
					matrix.method_22909();

					RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);

					CarryRenderHelper.renderBakedModel(tileItem, copy, buffer, light, model);

					matrix.method_22909();
				} else if (carry.isCarrying(CarryType.ENTITY)) {
					class_1297 entity = CarryRenderHelper.getRenderEntity(player);

					if (entity != null) {
						CarryRenderHelper.applyEntityTransformations(player, partialticks, matrix, entity);

						manager.method_3948(false);

						Optional<CarryOnScript> res = carry.getActiveScript();
						if (res.isPresent()) {
							CarryOnScript script = res.get();
							CarryRenderHelper.performScriptTransformation(matrix, script);
						}

						if (entity instanceof class_1309 le)
							le.field_6235 = 0;

						RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);

						manager.method_3954(entity, 0, 0, 0, 0f, 0, matrix, buffer, light);
						matrix.method_22909();
						manager.method_3948(true);
						matrix.method_22909();
					}
				}


			}
			catch (Exception e)
			{
			}

		}
		buffer.method_37104();

		buffer.method_22994(class_1921.method_23572(class_1059.field_5275));
		buffer.method_22994(class_1921.method_23576(class_1059.field_5275));
		buffer.method_22994(class_1921.method_23578(class_1059.field_5275));
		buffer.method_22994(class_1921.method_23584(class_1059.field_5275));

		RenderSystem.enableDepthTest();
		RenderSystem.enableCull();
		RenderSystem.disableBlend();
	}

}

