/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.client.modeloverride;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import tschipp.carryon.common.scripting.Matchables.NBTCondition;

import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2259;
import net.minecraft.class_2259.class_7211;
import net.minecraft.class_2291;
import net.minecraft.class_2291.class_7215;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import java.util.Map;
import java.util.Map.Entry;

public class ModelOverride
{
	//public static Codec<ModelOverride> CODEC = Codec.STRING.comapFlatMap(ModelOverride::of, override -> override.raw);

	private String raw;
	private class_7211 parsedBlock;
	private Type type;
	private Either<class_7215, class_7211> parsedRHS;
	private Either<class_1799, class_2680> renderObject;

	private ModelOverride(String raw, class_7211 parsedBlock, Type type, Either<class_7215, class_7211> parsedRHS)
	{
		this.raw = raw;
		this.parsedBlock = parsedBlock;
		this.type = type;
		this.parsedRHS = parsedRHS;

		parsedRHS.ifLeft(res -> {
			class_1799 stack = new class_1799(res.comp_628());
			if(res.comp_2439() != null)
				stack.method_57366(res.comp_2439());
			this.renderObject = Either.left(stack);
		});

		parsedRHS.ifRight(res -> {
			class_2680 state = res.comp_622();
			this.renderObject = Either.right(state);
		});
	}

	public static DataResult<ModelOverride> of(String str, class_7225.class_7874 provider)
	{
		if(!str.contains("->"))
			return DataResult.error(() -> str + " must contain -> Arrow!");
		String[] split = str.split("->");
		String from = split[0];
		String to = split[1];

		class_7211 res;

		try {
			res = class_2259.method_41957(class_7923.field_41175.method_46771(), from, true);
		} catch (Exception e) {
			return DataResult.error(() -> "Error while parsing " + from + ":" + e.getMessage());
		}

		Type type = Type.ITEM;

		if(to.contains("(") && to.contains(")"))
		{
			String t = to.substring(to.indexOf("(") + 1, to.indexOf(")"));
			if(t.equals("block"))
				type = Type.BLOCK;
			to = to.substring(to.indexOf(")") + 1);
		}

		Either<class_7215, class_7211> either;
		try {
			if(type == Type.ITEM)
				either = Either.left(new class_2291(provider).method_9789(new StringReader(to)));
			else
				either = Either.right(class_2259.method_41957(class_7923.field_41175.method_46771(), to, true));
		}catch (CommandSyntaxException e) {
			String finalTo = to;
			return DataResult.error(() -> "Error while parsing " + finalTo + ":" + e.getMessage());
		}

		return DataResult.success(new ModelOverride(str, res, type, either));
	}

	public boolean matches(class_2680 state, @Nullable class_2487 tag)
	{
		if(state.method_26204() == parsedBlock.comp_622().method_26204() && matchesProperties(state, parsedBlock.comp_623()))
		{
			if(tag == null || parsedBlock.comp_624() == null)
				return true;
			NBTCondition nbt = new NBTCondition(parsedBlock.comp_624());
			return nbt.matches(tag);
		}
		return false;
	}

	public Either<class_1799, class_2680> getRenderObject()
	{
		return this.renderObject;
	}

	private boolean matchesProperties(class_2680 state, Map<class_2769<?>, Comparable<?>> props)
	{
		for(var entry : props.entrySet())
		{
			var val = state.method_11654(entry.getKey());
			if(val != entry.getValue())
				return false;
		}
		return true;
	}

	public enum Type {
		ITEM,
		BLOCK
	}

}
