/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7877;
import net.minecraft.class_7923;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnData.CarryType;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.carry.PlacementHandler;
import tschipp.carryon.common.command.CommandCarryOn;
import tschipp.carryon.config.ConfigLoader;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingPacket;
import tschipp.carryon.networking.clientbound.ClientboundSyncScriptsPacket;
import tschipp.carryon.networking.serverbound.ServerboundCarryKeyPressedPacket;
import tschipp.carryon.platform.Services;

public class CarryOnCommon
{
	public static final class_7877 BUILDER = new class_7877();

	public static class_7225.class_7874 createLookup() {
		class_5455.class_6890 registryaccess$frozen = class_5455.method_40302(class_7923.field_41167);
		class_7225.class_7874 holderlookup$provider = BUILDER.method_46780(registryaccess$frozen);
		return holderlookup$provider;
	}

	public static void registerServerPackets(Object... args)
	{
		Services.PLATFORM.registerServerboundPacket(
				ServerboundCarryKeyPressedPacket.TYPE,
				ServerboundCarryKeyPressedPacket.class,
				ServerboundCarryKeyPressedPacket.CODEC,
				ServerboundCarryKeyPressedPacket::handle,
				args
		);
	}

	public static void registerClientPackets(Object... args)
	{
		Services.PLATFORM.registerClientboundPacket(
				ClientboundStartRidingPacket.TYPE,
				ClientboundStartRidingPacket.class,
				ClientboundStartRidingPacket.CODEC,
				ClientboundStartRidingPacket::handle,
				args
		);

		Services.PLATFORM.registerClientboundPacket(
				ClientboundSyncScriptsPacket.TYPE,
				ClientboundSyncScriptsPacket.class,
				ClientboundSyncScriptsPacket.CODEC,
				ClientboundSyncScriptsPacket::handle,
				args
		);
	}

	public static void registerConfig()
	{
		ConfigLoader.registerConfig(Constants.COMMON_CONFIG);
		ConfigLoader.registerConfig(Constants.CLIENT_CONFIG);
	}

	public static void registerCommands(CommandDispatcher<class_2168> dispatcher)
	{
		CommandCarryOn.register(dispatcher);
	}


	public static void onCarryTick(class_3222 player)
	{
	    CarryOnData carry = CarryOnDataManager.getCarryData(player);
	    if(carry.isCarrying())
	    {
	        if(carry.getActiveScript().isPresent())
	        {
	            String cmd = carry.getActiveScript().get().scriptEffects().commandLoop();
	            if(!cmd.isEmpty())
	                player.method_5682().method_3734().method_44252(player.method_5682().method_3739(), "/execute as " + player.method_7334().getName() + " run " + cmd);
	        }

		    if (!Constants.COMMON_CONFIG.settings.slownessInCreative && player.method_7337())
			    return;

		    player.method_6092(new class_1293(class_1294.field_5909, 1, potionLevel(carry, player.method_37908()), false, false));

		    class_1661 inv = player.method_31548();
			inv.field_7545 = carry.getSelected();
	    }
	}

	/**
	 * Returns true if the block can be broken.
	 */
	public static boolean onTryBreakBlock(class_1657 player)
	{
		if (player != null && !Constants.COMMON_CONFIG.settings.hitWhileCarrying)
		{
			CarryOnData carry = CarryOnDataManager.getCarryData(player);
			if(carry.isCarrying())
				return false;
		}
		return true;
	}

	/**
	 * Returns true of the entity can be attacked
	 */
	public static boolean onAttackedByPlayer(class_1657 player)
	{
		if (player != null && !Constants.COMMON_CONFIG.settings.hitWhileCarrying)
		{
			CarryOnData carry = CarryOnDataManager.getCarryData(player);
			if(carry.isCarrying())
				return false;
		}
		return true;
	}

	public static void onPlayerAttacked(class_1657 player)
	{
		if (Constants.COMMON_CONFIG.settings.dropCarriedWhenHit && !player.method_37908().field_9236)
		{
			CarryOnData carry = CarryOnDataManager.getCarryData(player);
			if (carry.isCarrying())
			{
				PlacementHandler.placeCarried((class_3222) player);
			}

		}
	}


	private static int potionLevel(CarryOnData carry, class_1937 level)
	{
		if(carry.isCarrying(CarryType.PLAYER))
			return 1;
		if(carry.isCarrying(CarryType.ENTITY))
		{
			class_1297 entity = carry.getEntity(level);
			int i = (int) (entity.method_17682() * entity.method_17681());
			if (i > 4)
				i = 4;
			if (!Constants.COMMON_CONFIG.settings.heavyEntities)
				i = 1;
			return (int) (i * Constants.COMMON_CONFIG.settings.entitySlownessMultiplier);
		}
		if(carry.isCarrying(CarryType.BLOCK))
		{
			String nbt = carry.getNbt().toString();
			int i = nbt.length() / 500;

			if (i > 4)
				i = 4;

			if (!Constants.COMMON_CONFIG.settings.heavyTiles)
				i = 1;

			return (int) (i * Constants.COMMON_CONFIG.settings.blockSlownessMultiplier);
		}
		return 0;
	}
}
