/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.scripting;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3614;
import net.minecraft.class_7923;
import tschipp.carryon.Constants;
import tschipp.carryon.common.scripting.CarryOnScript;

public class ScriptManager {
    public static final List<CarryOnScript> SCRIPTS = new ArrayList<CarryOnScript>();

    public static Optional<CarryOnScript> inspectBlock(class_2680 state, class_1937 level, class_2338 pos, @Nullable class_2487 tag) {
        if (!Constants.COMMON_CONFIG.settings.useScripts) {
            return Optional.empty();
        }
        class_2248 block = state.method_26204();
        class_3614 material = state.method_26207();
        float hardness = state.method_26214((class_1922)level, pos);
        float resistance = block.method_9520();
        for (CarryOnScript script : SCRIPTS) {
            if (!script.isBlock() || !ScriptManager.matchesAll(script, block, material, hardness, resistance, tag)) continue;
            return Optional.of(script);
        }
        return Optional.empty();
    }

    public static Optional<CarryOnScript> inspectEntity(class_1297 entity) {
        if (!Constants.COMMON_CONFIG.settings.useScripts) {
            return Optional.empty();
        }
        float height = entity.method_17682();
        float width = entity.method_17681();
        float health = entity instanceof class_1309 ? ((class_1309)entity).method_6032() : 0.0f;
        class_2487 tag = new class_2487();
        entity.method_5662(tag);
        for (CarryOnScript script : SCRIPTS) {
            if (!script.isEntity() || !ScriptManager.matchesAll(script, entity, height, width, health, tag)) continue;
            return Optional.of(script);
        }
        return Optional.empty();
    }

    private static boolean matchesAll(CarryOnScript script, class_1297 entity, float height, float width, float health, class_2487 tag) {
        CarryOnScript.ScriptObject.ScriptObjectEntity scEntity = script.scriptObject().entity();
        boolean matchname = true;
        if (scEntity.typeNameEntity().isPresent()) {
            matchname = entity.method_5864().equals(class_7923.field_41177.method_29107(scEntity.typeNameEntity().get()));
        }
        boolean matchheight = scEntity.typeHeight().matches(Float.valueOf(height));
        boolean matchwidth = scEntity.typeWidth().matches(Float.valueOf(width));
        boolean matchhealth = scEntity.typeHealth().matches(Float.valueOf(health));
        boolean matchnbt = scEntity.typeEntityTag().matches(tag);
        return matchname && matchheight && matchwidth && matchhealth && matchnbt;
    }

    private static boolean matchesAll(CarryOnScript script, class_2248 block, class_3614 material, float hardness, float resistance, class_2487 nbt) {
        CarryOnScript.ScriptObject.ScriptObjectBlock scBlock = script.scriptObject().block();
        boolean matchblock = true;
        if (scBlock.typeNameBlock().isPresent()) {
            matchblock = block == class_7923.field_41175.method_29107(scBlock.typeNameBlock().get());
        }
        boolean matchnbt = scBlock.typeBlockTag().matches(nbt);
        boolean matchmaterial = scBlock.typeMaterial().matches(material);
        boolean matchhardness = scBlock.typeHardness().matches(Float.valueOf(hardness));
        boolean matchresistance = scBlock.typeResistance().matches(Float.valueOf(resistance));
        return matchnbt && matchblock && matchmaterial && matchhardness && matchresistance;
    }
}

