/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.scripting;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_267;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_2989;
import net.minecraft.class_3222;
import net.minecraft.class_3614;
import net.minecraft.class_7923;
import tschipp.carryon.platform.Services;

public final class Matchables {
    private static float getValueFromStringOrDefault(String toGetFrom, String key, float defaultVal) {
        Optional<Float> val = Matchables.getValueFromString(toGetFrom, key);
        if (val.isPresent()) {
            return val.get().floatValue();
        }
        return defaultVal;
    }

    private static Optional<Float> getValueFromString(String toGetFrom, String key) {
        String[] s;
        if (toGetFrom == null || toGetFrom.isEmpty()) {
            return Optional.empty();
        }
        for (String string : s = toGetFrom.split(",")) {
            if (!string.contains(key) || !string.contains("=")) continue;
            float numb = 0.0f;
            string = string.replace(key + "=", "");
            try {
                numb = Float.parseFloat(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Optional.of(Float.valueOf(numb));
        }
        return Optional.empty();
    }

    public static class OptionalVec3 {
        public static final Codec<OptionalVec3> CODEC = Codec.STRING.xmap(OptionalVec3::new, OptionalVec3::source);
        public static final OptionalVec3 NONE = new OptionalVec3("");
        String source;
        class_243 vec;
        boolean x;
        boolean y;
        boolean z;

        public OptionalVec3(String source) {
            this.source = source;
            Optional<Float> xOpt = Matchables.getValueFromString(source, "x");
            Optional<Float> yOpt = Matchables.getValueFromString(source, "y");
            Optional<Float> zOpt = Matchables.getValueFromString(source, "z");
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            if (xOpt.isPresent()) {
                x = xOpt.get().floatValue();
                this.x = true;
            }
            if (yOpt.isPresent()) {
                y = yOpt.get().floatValue();
                this.y = true;
            }
            if (zOpt.isPresent()) {
                z = zOpt.get().floatValue();
                this.z = true;
            }
            this.vec = new class_243((double)x, (double)y, (double)z);
        }

        private String source() {
            return this.source;
        }

        public class_243 getVec() {
            return this.vec;
        }

        public class_243 getVec(double dX, double dY, double dZ) {
            double x = !this.x ? dX : this.vec.field_1352;
            double y = !this.y ? dY : this.vec.field_1351;
            double z = !this.z ? dZ : this.vec.field_1350;
            return new class_243(x, y, z);
        }
    }

    public record NBTCondition(class_2487 tag) implements Matchable<class_2487>
    {
        public static final Codec<NBTCondition> CODEC = class_2487.field_25128.xmap(NBTCondition::new, NBTCondition::tag);
        public static final NBTCondition NONE = new NBTCondition(new class_2487());

        @Override
        public boolean matches(class_2487 other) {
            if (other == null) {
                return true;
            }
            return class_2512.method_10687((class_2520)this.tag, (class_2520)other, (boolean)true);
        }
    }

    public record EffectsCondition(String effects) implements Matchable<class_3222>
    {
        public static final Codec<EffectsCondition> CODEC = Codec.STRING.xmap(EffectsCondition::new, EffectsCondition::effects);
        public static final EffectsCondition NONE = new EffectsCondition("");

        @Override
        public boolean matches(class_3222 player) {
            int lev;
            if (this.effects == null || this.effects.isEmpty()) {
                return true;
            }
            Collection fx = player.method_6026();
            String[] potions = this.effects.split(",");
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Integer> levels = new ArrayList<Integer>();
            for (String pot : potions) {
                if (pot.contains("#")) {
                    String level = pot.substring(pot.indexOf("#"));
                    String name = pot.substring(0, pot.indexOf("#"));
                    level = level.replace("#", "");
                    lev = 0;
                    try {
                        lev = Integer.parseInt(level);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    levels.add(lev);
                    names.add(name);
                    continue;
                }
                levels.add(0);
                names.add(pot);
            }
            int matches = 0;
            for (class_1293 effect : fx) {
                int idx;
                int amp = effect.method_5578();
                String name = class_7923.field_41174.method_10221((Object)effect.method_5579()).toString();
                if (!names.contains(name) || (lev = ((Integer)levels.get(idx = names.indexOf(name))).intValue()) > amp) continue;
                ++matches;
            }
            return matches == potions.length;
        }
    }

    public record PositionCondition(String cond) implements Matchable<class_3222>
    {
        public static final Codec<PositionCondition> CODEC = Codec.STRING.xmap(PositionCondition::new, PositionCondition::cond);
        public static final PositionCondition NONE = new PositionCondition("");

        @Override
        public boolean matches(class_3222 elem) {
            if (this.cond == null || this.cond.isEmpty()) {
                return true;
            }
            class_2338 blockpos = new class_2338((double)Matchables.getValueFromStringOrDefault(this.cond, "x", 0.0f), (double)Matchables.getValueFromStringOrDefault(this.cond, "y", 0.0f), (double)Matchables.getValueFromStringOrDefault(this.cond, "z", 0.0f));
            class_2338 expand = new class_2338((double)Matchables.getValueFromStringOrDefault(this.cond, "dx", 0.0f), (double)Matchables.getValueFromStringOrDefault(this.cond, "dy", 0.0f), (double)Matchables.getValueFromStringOrDefault(this.cond, "dz", 0.0f));
            class_2338 expanded = blockpos.method_10081((class_2382)expand);
            class_2338 pos = elem.method_24515();
            boolean x = pos.method_10263() >= blockpos.method_10263() && pos.method_10263() <= expanded.method_10263() || blockpos.method_10263() == 0;
            boolean y = pos.method_10264() >= blockpos.method_10264() && pos.method_10264() <= expanded.method_10264() || blockpos.method_10264() == 0;
            boolean z = pos.method_10260() >= blockpos.method_10260() && pos.method_10260() <= expanded.method_10260() || blockpos.method_10260() == 0;
            return x && y && z;
        }
    }

    public record ScoreboardCondition(String cond) implements Matchable<class_3222>
    {
        public static final Codec<ScoreboardCondition> CODEC = Codec.STRING.xmap(ScoreboardCondition::new, ScoreboardCondition::cond);
        public static final ScoreboardCondition NONE = new ScoreboardCondition("");

        @Override
        public boolean matches(class_3222 player) {
            class_267 sc;
            if (this.cond == null || this.cond.isEmpty()) {
                return true;
            }
            class_269 score = player.method_7327();
            int iE = this.cond.indexOf("=");
            int iG = this.cond.indexOf(">");
            int iL = this.cond.indexOf("<");
            String numb = iG == -1 || iE < iG && iL == -1 || iE < iL && iE != -1 ? this.cond.substring(iE) : (iE == -1 || iG < iE && iL == -1 || iG < iL && iG != -1 ? this.cond.substring(iG) : this.cond.substring(iL));
            String scorename = this.cond.replace(numb, "");
            Map o = score.method_1166(player.method_7334().getName());
            if (o != null && (sc = (class_267)o.get(score.method_1170(scorename))) != null) {
                int points = sc.method_1126();
                return new NumberBoundCondition(numb).matches(points);
            }
            return false;
        }
    }

    public record GamestageCondition(String gamestage) implements Matchable<class_3222>
    {
        public static final Codec<GamestageCondition> CODEC = Codec.STRING.xmap(GamestageCondition::new, GamestageCondition::gamestage);
        public static final GamestageCondition NONE = new GamestageCondition("");

        @Override
        public boolean matches(class_3222 player) {
            if (!Services.PLATFORM.isModLoaded("gamestages")) {
                return true;
            }
            if (this.gamestage == null || this.gamestage.isEmpty()) {
                return true;
            }
            return Services.GAMESTAGES.hasStage((class_1657)player, this.gamestage);
        }
    }

    public record AdvancementCondition(String advancement) implements Matchable<class_3222>
    {
        public static final Codec<AdvancementCondition> CODEC = Codec.STRING.xmap(AdvancementCondition::new, AdvancementCondition::advancement);
        public static final AdvancementCondition NONE = new AdvancementCondition("");

        @Override
        public boolean matches(class_3222 player) {
            class_2989 manager = player.field_13995.method_3851();
            class_161 adv = manager.method_12896(new class_2960(this.advancement.isEmpty() ? "" : this.advancement));
            boolean achievement = adv == null ? true : player.method_14236().method_12882(adv).method_740();
            return achievement;
        }
    }

    public record MaterialCondition(String material) implements Matchable<class_3614>
    {
        public static final Codec<MaterialCondition> CODEC = Codec.STRING.xmap(MaterialCondition::new, MaterialCondition::material);
        public static final MaterialCondition NONE = new MaterialCondition("");

        @Override
        public boolean matches(class_3614 material) {
            if (this.material == null || this.material.isEmpty()) {
                return true;
            }
            switch (this.material) {
                case "air": {
                    return material == class_3614.field_15959;
                }
                case "anvil": {
                    return material == class_3614.field_15949;
                }
                case "barrier": {
                    return material == class_3614.field_15952;
                }
                case "cactus": {
                    return material == class_3614.field_15925;
                }
                case "cake": {
                    return material == class_3614.field_15937;
                }
                case "carpet": {
                    return material == class_3614.field_15957;
                }
                case "clay": {
                    return material == class_3614.field_15936;
                }
                case "cloth": {
                    return material == class_3614.field_15931;
                }
                case "dragon_egg": {
                    return material == class_3614.field_15930;
                }
                case "fire": {
                    return material == class_3614.field_15943;
                }
                case "glass": {
                    return material == class_3614.field_15942;
                }
                case "gourd": {
                    return material == class_3614.field_15954;
                }
                case "grass": {
                    return material == class_3614.field_15945;
                }
                case "ground": {
                    return material == class_3614.field_15945;
                }
                case "ice": {
                    return material == class_3614.field_15958;
                }
                case "iron": {
                    return material == class_3614.field_15953;
                }
                case "lava": {
                    return material == class_3614.field_15922;
                }
                case "leaves": {
                    return material == class_3614.field_15923;
                }
                case "packed_ice": {
                    return material == class_3614.field_15928;
                }
                case "piston": {
                    return material == class_3614.field_15933;
                }
                case "plants": {
                    return material == class_3614.field_15935;
                }
                case "portal": {
                    return material == class_3614.field_15919;
                }
                case "redstone_light": {
                    return material == class_3614.field_15918;
                }
                case "rock": {
                    return material == class_3614.field_15914;
                }
                case "sand": {
                    return material == class_3614.field_15916;
                }
                case "snow": {
                    return material == class_3614.field_15948;
                }
                case "sponge": {
                    return material == class_3614.field_15917;
                }
                case "structure_void": {
                    return material == class_3614.field_15927;
                }
                case "tnt": {
                    return material == class_3614.field_15955;
                }
                case "vine": {
                    return material == class_3614.field_15935;
                }
                case "water": {
                    return material == class_3614.field_15920;
                }
                case "web": {
                    return material == class_3614.field_15913;
                }
                case "wood": {
                    return material == class_3614.field_15932;
                }
            }
            return false;
        }
    }

    public record NumberBoundCondition(String bounds) implements Matchable<Number>
    {
        public static final Codec<NumberBoundCondition> CODEC = Codec.STRING.xmap(NumberBoundCondition::new, NumberBoundCondition::bounds);
        public static final NumberBoundCondition NONE = new NumberBoundCondition("");

        @Override
        public boolean matches(Number num) {
            double number = num.doubleValue();
            if (this.bounds == null || this.bounds.isEmpty()) {
                return true;
            }
            try {
                if (this.bounds.contains("<=")) {
                    return number <= Double.parseDouble(this.bounds.replace("<=", ""));
                }
                if (this.bounds.contains(">=")) {
                    return number >= Double.parseDouble(this.bounds.replace(">=", ""));
                }
                if (this.bounds.contains("<")) {
                    return number < Double.parseDouble(this.bounds.replace("<", ""));
                }
                if (this.bounds.contains(">")) {
                    return number > Double.parseDouble(this.bounds.replace(">", ""));
                }
                if (this.bounds.contains("=")) {
                    return number == Double.parseDouble(this.bounds.replace("=", ""));
                }
                return number == Double.parseDouble(this.bounds);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while parsing Number bound for string: " + this.bounds + ". Error: " + e.getMessage());
            }
        }
    }

    public static interface Matchable<T> {
        public boolean matches(T var1);
    }
}

