package tschipp.carryon.mixin;

import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.carry.PlacementHandler;

@Mixin(class_1657.class)
public class PlayerMixinFabric
{
	@Inject(at = @At("HEAD"), method = "hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")
	private void onHurt(class_1282 damageSource, float f, CallbackInfoReturnable<Boolean> cir) {
		if(Constants.COMMON_CONFIG.settings.dropCarriedWhenHit)
		{
			class_1657 player = ((class_1657)(Object)this);
			CarryOnData carry = CarryOnDataManager.getCarryData(player);
			if(carry.isCarrying() && !player.field_6002.field_9236)
				PlacementHandler.placeCarried((class_3222)player);
		}

	}
}
