package tschipp.carryon.events;

import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.*;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1269;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import tschipp.carryon.CarryOnCommon;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnData.CarryType;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.carry.PickupHandler;
import tschipp.carryon.common.carry.PlacementHandler;
import tschipp.carryon.common.scripting.ScriptReloadListener;
import tschipp.carryon.config.ConfigLoader;
import tschipp.carryon.scripting.IdentifiableScriptReloadListener;

public class CommonEvents {

    public static void registerEvents() {

        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            if(!client)
                ConfigLoader.onConfigLoaded();
        });

        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {

            if(world.field_9236)
                return class_1269.field_5811;

            class_2338 pos = hitResult.method_17777();
            class_2350 facing = hitResult.method_17780();

            CarryOnData carry = CarryOnDataManager.getCarryData(player);
            if(!carry.isCarrying())
            {
                if (PickupHandler.tryPickUpBlock((class_3222) player, pos, world, null))
                    return class_1269.field_5812;
                return class_1269.field_5811;
            }
            else
            {
                if(carry.isCarrying(CarryOnData.CarryType.BLOCK))
                {
                    if(PlacementHandler.tryPlaceBlock((class_3222) player, pos, facing, null))
                        return class_1269.field_5812;
                }
                else
                {
                    if(PlacementHandler.tryPlaceEntity((class_3222) player, pos, facing, null))
                        return class_1269.field_5812;
                }

                //Fail here, so that we don't interact with placed things
                return class_1269.field_5814;
            }
        });




        UseEntityCallback.EVENT.register((player, level, hand, entity, hitResult) -> {

            if(level.field_9236)
                return class_1269.field_5811;

            CarryOnData carry = CarryOnDataManager.getCarryData(player);
            if (!carry.isCarrying()) {
                if (PickupHandler.tryPickupEntity((class_3222) player, entity, null)) {
                    return class_1269.field_5812;
                }
            }
            else if(carry.isCarrying(CarryOnData.CarryType.ENTITY) || carry.isCarrying(CarryType.PLAYER))
            {
                PlacementHandler.tryStackEntity((class_3222) player, entity);
            }

            return class_1269.field_5811;
        });


        CommandRegistrationCallback.EVENT.register(((dispatcher, registryAccess, environment) -> {
            CarryOnCommon.registerCommands(dispatcher);
        }));


        ResourceManagerHelper.get(class_3264.field_14190).registerReloadListener(new IdentifiableScriptReloadListener());


        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> {
            ScriptReloadListener.syncScriptsWithClient(player);
        });


        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for(class_3222 player : server.method_3760().method_14571())
                CarryOnCommon.onCarryTick(player);
        });


        ServerPlayerEvents.COPY_FROM.register(((oldPlayer, newPlayer, alive) -> {
            PlacementHandler.placeCarriedOnDeath(oldPlayer, newPlayer, !alive);
        }));


        PlayerBlockBreakEvents.BEFORE.register(((world, player, pos, state, blockEntity) -> {
            if(!CarryOnCommon.onTryBreakBlock(player))
                return false;
            return true;
        }));

        AttackBlockCallback.EVENT.register(((player, world, hand, pos, direction) -> {
            if(!CarryOnCommon.onTryBreakBlock(player))
                return class_1269.field_5812;
            return class_1269.field_5811;
        }));

        AttackEntityCallback.EVENT.register(((player, world, hand, entity, hitResult) -> {
            if(!CarryOnCommon.onAttackedByPlayer(player))
                return class_1269.field_5812;
            return class_1269.field_5811;
        }));

        //TODO: drop carried when attacked
    }

}
