package tschipp.carryon;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.events.ClientEvents;
import tschipp.carryon.networking.PacketBase;

import java.util.function.BiConsumer;
import java.util.function.Function;

public class CarryOnFabricClientMod implements ClientModInitializer
{
	@Override
	public void onInitializeClient()
	{
		CarryOnKeybinds.registerKeybinds(KeyBindingHelper::registerKeyBinding);
		ClientEvents.registerEvents();
		CarryOnCommon.registerClientPackets();
	}

	public static void sendPacketToServer(class_2960 id, PacketBase packet)
	{
		class_2540 buf = PacketByteBufs.create();
		packet.toBytes(buf);
		ClientPlayNetworking.send(id, buf);
	}

	public static <T extends PacketBase> void registerClientboundPacket(class_2960 id, Function<class_2540, T> reader, BiConsumer<T, class_1657> handler)
	{
		ClientPlayNetworking.registerGlobalReceiver(id, (client, packetHandler, buf, responseSender) -> {
			T packet = reader.apply(buf);
			client.execute(() -> {
				handler.accept(packet, client.field_1724);
			});
		});
	}
}
