/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.scripting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import tschipp.carryon.common.scripting.Matchables;

public record CarryOnScript(long priority, ScriptObject scriptObject, ScriptConditions scriptConditions, ScriptRender scriptRender, ScriptEffects scriptEffects) {
    public static final Codec<CarryOnScript> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.optionalFieldOf("priority", (Object)0L).forGetter(CarryOnScript::priority), (App)ScriptObject.CODEC.fieldOf("object").forGetter(CarryOnScript::scriptObject), (App)ScriptConditions.CODEC.optionalFieldOf("conditions", (Object)ScriptConditions.EMPTY).forGetter(CarryOnScript::scriptConditions), (App)ScriptRender.CODEC.optionalFieldOf("render", (Object)ScriptRender.EMPTY).forGetter(CarryOnScript::scriptRender), (App)ScriptEffects.CODEC.optionalFieldOf("effects", (Object)ScriptEffects.EMPTY).forGetter(CarryOnScript::scriptEffects)).apply((Applicative)instance, CarryOnScript::new));

    public boolean isValid() {
        return this.isBlock() ^ this.isEntity() && (this.scriptConditions != ScriptConditions.EMPTY || this.scriptRender != ScriptRender.EMPTY || this.scriptEffects != ScriptEffects.EMPTY);
    }

    public boolean isBlock() {
        return this.scriptObject.block() != ScriptObject.ScriptObjectBlock.EMPTY;
    }

    public boolean isEntity() {
        return this.scriptObject.entity() != ScriptObject.ScriptObjectEntity.EMPTY;
    }

    public boolean fulfillsConditions(class_3222 player) {
        ScriptConditions cond = this.scriptConditions();
        boolean achievement = cond.conditionAchievement.matches(player);
        boolean gamemode = cond.conditionGamemode.matches(player.field_13974.method_14257().method_8379());
        boolean gamestage = cond.conditionGamestage.matches(player);
        boolean position = cond.conditionPosition.matches(player);
        boolean xp = cond.conditionXp.matches(player.field_7520);
        boolean scoreboard = cond.conditionScoreboard.matches(player);
        boolean effects = cond.conditionEffects.matches(player);
        return achievement && gamemode && gamestage && position && xp && scoreboard && effects;
    }

    public record ScriptObject(ScriptObjectBlock block, ScriptObjectEntity entity) {
        public static final Codec<ScriptObject> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ScriptObjectBlock.CODEC.optionalFieldOf("block", (Object)ScriptObjectBlock.EMPTY).forGetter(ScriptObject::block), (App)ScriptObjectEntity.CODEC.optionalFieldOf("entity", (Object)ScriptObjectEntity.EMPTY).forGetter(ScriptObject::entity)).apply((Applicative)instance, ScriptObject::new));

        public record ScriptObjectBlock(Optional<class_5321<class_2248>> typeNameBlock, Matchables.MaterialCondition typeMaterial, Matchables.NumberBoundCondition typeHardness, Matchables.NumberBoundCondition typeResistance, Matchables.NBTCondition typeBlockTag) {
            public static final ScriptObjectBlock EMPTY = new ScriptObjectBlock(Optional.empty(), Matchables.MaterialCondition.NONE, Matchables.NumberBoundCondition.NONE, Matchables.NumberBoundCondition.NONE, Matchables.NBTCondition.NONE);
            public static final Codec<ScriptObjectBlock> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41254).optionalFieldOf("name").forGetter(ScriptObjectBlock::typeNameBlock), (App)Matchables.MaterialCondition.CODEC.optionalFieldOf("material", (Object)Matchables.MaterialCondition.NONE).forGetter(ScriptObjectBlock::typeMaterial), (App)Matchables.NumberBoundCondition.CODEC.optionalFieldOf("hardness", (Object)Matchables.NumberBoundCondition.NONE).forGetter(ScriptObjectBlock::typeHardness), (App)Matchables.NumberBoundCondition.CODEC.optionalFieldOf("resistance", (Object)Matchables.NumberBoundCondition.NONE).forGetter(ScriptObjectBlock::typeResistance), (App)Matchables.NBTCondition.CODEC.optionalFieldOf("nbt", (Object)Matchables.NBTCondition.NONE).forGetter(ScriptObjectBlock::typeBlockTag)).apply((Applicative)instance, ScriptObjectBlock::new));
        }

        public record ScriptObjectEntity(Optional<class_5321<class_1299<?>>> typeNameEntity, Matchables.NumberBoundCondition typeHealth, Matchables.NumberBoundCondition typeHeight, Matchables.NumberBoundCondition typeWidth, Matchables.NBTCondition typeEntityTag) {
            public static final ScriptObjectEntity EMPTY = new ScriptObjectEntity(Optional.empty(), Matchables.NumberBoundCondition.NONE, Matchables.NumberBoundCondition.NONE, Matchables.NumberBoundCondition.NONE, Matchables.NBTCondition.NONE);
            public static final Codec<ScriptObjectEntity> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41266).optionalFieldOf("name").forGetter(ScriptObjectEntity::typeNameEntity), (App)Matchables.NumberBoundCondition.CODEC.optionalFieldOf("health", (Object)Matchables.NumberBoundCondition.NONE).forGetter(ScriptObjectEntity::typeHealth), (App)Matchables.NumberBoundCondition.CODEC.optionalFieldOf("height", (Object)Matchables.NumberBoundCondition.NONE).forGetter(ScriptObjectEntity::typeHeight), (App)Matchables.NumberBoundCondition.CODEC.optionalFieldOf("width", (Object)Matchables.NumberBoundCondition.NONE).forGetter(ScriptObjectEntity::typeWidth), (App)Matchables.NBTCondition.CODEC.optionalFieldOf("nbt", (Object)Matchables.NBTCondition.NONE).forGetter(ScriptObjectEntity::typeEntityTag)).apply((Applicative)instance, ScriptObjectEntity::new));
        }
    }

    public record ScriptConditions(Matchables.GamestageCondition conditionGamestage, Matchables.AdvancementCondition conditionAchievement, Matchables.NumberBoundCondition conditionXp, Matchables.NumberBoundCondition conditionGamemode, Matchables.ScoreboardCondition conditionScoreboard, Matchables.PositionCondition conditionPosition, Matchables.EffectsCondition conditionEffects) {
        public static final ScriptConditions EMPTY = new ScriptConditions(Matchables.GamestageCondition.NONE, Matchables.AdvancementCondition.NONE, Matchables.NumberBoundCondition.NONE, Matchables.NumberBoundCondition.NONE, Matchables.ScoreboardCondition.NONE, Matchables.PositionCondition.NONE, Matchables.EffectsCondition.NONE);
        public static final Codec<ScriptConditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Matchables.GamestageCondition.CODEC.optionalFieldOf("gamestage", (Object)Matchables.GamestageCondition.NONE).forGetter(ScriptConditions::conditionGamestage), (App)Matchables.AdvancementCondition.CODEC.optionalFieldOf("advancement", (Object)Matchables.AdvancementCondition.NONE).forGetter(ScriptConditions::conditionAchievement), (App)Matchables.NumberBoundCondition.CODEC.optionalFieldOf("xp", (Object)Matchables.NumberBoundCondition.NONE).forGetter(ScriptConditions::conditionXp), (App)Matchables.NumberBoundCondition.CODEC.optionalFieldOf("gamemode", (Object)Matchables.NumberBoundCondition.NONE).forGetter(ScriptConditions::conditionGamemode), (App)Matchables.ScoreboardCondition.CODEC.optionalFieldOf("scoreboard", (Object)Matchables.ScoreboardCondition.NONE).forGetter(ScriptConditions::conditionScoreboard), (App)Matchables.PositionCondition.CODEC.optionalFieldOf("position", (Object)Matchables.PositionCondition.NONE).forGetter(ScriptConditions::conditionPosition), (App)Matchables.EffectsCondition.CODEC.optionalFieldOf("effects", (Object)Matchables.EffectsCondition.NONE).forGetter(ScriptConditions::conditionEffects)).apply((Applicative)instance, ScriptConditions::new));
    }

    public record ScriptRender(Optional<class_5321<class_2248>> renderNameBlock, Optional<class_5321<class_1299<?>>> renderNameEntity, Optional<class_2487> renderNBT, Matchables.OptionalVec3 renderTranslation, Matchables.OptionalVec3 renderRotation, Matchables.OptionalVec3 renderscale, Matchables.OptionalVec3 renderRotationLeftArm, Matchables.OptionalVec3 renderRotationRightArm, boolean renderLeftArm, boolean renderRightArm) {
        public static final ScriptRender EMPTY = new ScriptRender(Optional.empty(), Optional.empty(), Optional.empty(), Matchables.OptionalVec3.NONE, Matchables.OptionalVec3.NONE, Matchables.OptionalVec3.NONE, Matchables.OptionalVec3.NONE, Matchables.OptionalVec3.NONE, true, true);
        public static final Codec<ScriptRender> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41254).optionalFieldOf("name_block").forGetter(ScriptRender::renderNameBlock), (App)class_5321.method_39154((class_5321)class_7924.field_41266).optionalFieldOf("name_entity").forGetter(ScriptRender::renderNameEntity), (App)class_2487.field_25128.optionalFieldOf("nbt").forGetter(ScriptRender::renderNBT), (App)Matchables.OptionalVec3.CODEC.optionalFieldOf("translation", (Object)Matchables.OptionalVec3.NONE).forGetter(ScriptRender::renderTranslation), (App)Matchables.OptionalVec3.CODEC.optionalFieldOf("rotation", (Object)Matchables.OptionalVec3.NONE).forGetter(ScriptRender::renderRotation), (App)Matchables.OptionalVec3.CODEC.optionalFieldOf("scale", (Object)Matchables.OptionalVec3.NONE).forGetter(ScriptRender::renderscale), (App)Matchables.OptionalVec3.CODEC.optionalFieldOf("rotation_left_arm", (Object)Matchables.OptionalVec3.NONE).forGetter(ScriptRender::renderRotationLeftArm), (App)Matchables.OptionalVec3.CODEC.optionalFieldOf("rotation_right_arm", (Object)Matchables.OptionalVec3.NONE).forGetter(ScriptRender::renderRotationRightArm), (App)Codec.BOOL.optionalFieldOf("render_left_arm", (Object)true).forGetter(ScriptRender::renderLeftArm), (App)Codec.BOOL.optionalFieldOf("render_right_arm", (Object)true).forGetter(ScriptRender::renderRightArm)).apply((Applicative)instance, ScriptRender::new));
    }

    public record ScriptEffects(String commandInit, String commandLoop, String commandPlace) {
        public static final ScriptEffects EMPTY = new ScriptEffects("", "", "");
        public static final Codec<ScriptEffects> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("commandPickup", (Object)"").forGetter(ScriptEffects::commandInit), (App)Codec.STRING.optionalFieldOf("commandLoop", (Object)"").forGetter(ScriptEffects::commandLoop), (App)Codec.STRING.optionalFieldOf("commandPlace", (Object)"").forGetter(ScriptEffects::commandPlace)).apply((Applicative)instance, ScriptEffects::new));
    }
}

