/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import tschipp.carryon.Constants;
import tschipp.carryon.client.modeloverride.ModelOverride;
import tschipp.carryon.client.modeloverride.ModelOverrideHandler;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.carry.PlacementHandler;
import tschipp.carryon.common.pickupcondition.PickupCondition;
import tschipp.carryon.common.pickupcondition.PickupConditionHandler;

public class CommandCarryOn {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"carryon").then(class_2170.method_9247((String)"debug").executes(cmd -> CommandCarryOn.handleDebug((class_2168)cmd.getSource())))).then(class_2170.method_9247((String)"clear").executes(cmd -> CommandCarryOn.handleClear((class_2168)cmd.getSource(), Collections.singleton(((class_2168)cmd.getSource()).method_9207()))))).then(class_2170.method_9247((String)"clear").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).requires(src -> src.method_9259(2))).executes(cmd -> CommandCarryOn.handleClear((class_2168)cmd.getSource(), class_2186.method_9312((CommandContext)cmd, (String)"target")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"place").requires(src -> src.method_9259(2))).executes(cmd -> CommandCarryOn.handlePlace((class_2168)cmd.getSource(), Collections.singleton(((class_2168)cmd.getSource()).method_9207()))))).then(class_2170.method_9247((String)"place").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).requires(src -> src.method_9259(2))).executes(cmd -> CommandCarryOn.handlePlace((class_2168)cmd.getSource(), class_2186.method_9312((CommandContext)cmd, (String)"target")))));
        dispatcher.register(builder);
    }

    private static int handleDebug(class_2168 source) {
        try {
            if (source.method_9229() != null) {
                class_3222 player = source.method_9207();
                CarryOnData carry = CarryOnDataManager.getCarryData((class_1657)player);
                if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
                    Optional<PickupCondition> cond;
                    class_2680 block = carry.getBlock();
                    CommandCarryOn.log(source, "Block: " + block.method_26204());
                    CommandCarryOn.log(source, "BlockState: " + block);
                    CommandCarryOn.log(source, "NBT: " + carry.getNbt());
                    Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(block, carry.getContentNbt());
                    if (ov.isPresent()) {
                        CommandCarryOn.log(source, "Override Model: " + ov.get().getRenderObject());
                    }
                    if ((cond = PickupConditionHandler.getPickupCondition(block)).isPresent()) {
                        CommandCarryOn.log(source, "Custom Pickup Condition: " + cond.get().getCondition());
                    }
                    return 1;
                }
                if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
                    class_1297 entity = carry.getEntity(player.field_6002);
                    CommandCarryOn.log(source, "Entity: " + entity);
                    CommandCarryOn.log(source, "Entity Name: " + entity.method_5864());
                    CommandCarryOn.log(source, "NBT: " + carry.getNbt());
                    Optional<PickupCondition> cond = PickupConditionHandler.getPickupCondition(entity);
                    if (cond.isPresent()) {
                        CommandCarryOn.log(source, "Custom Pickup Condition: " + cond.get().getCondition());
                    }
                    return 1;
                }
                if (carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
                    CommandCarryOn.log(source, "Carrying Player.");
                }
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return 0;
    }

    private static int handleClear(class_2168 source, Collection<class_3222> players) {
        int cleared = 0;
        for (class_3222 player : players) {
            CarryOnData carry = CarryOnDataManager.getCarryData((class_1657)player);
            carry.clear();
            CarryOnDataManager.setCarryData((class_1657)player, carry);
            ++cleared;
        }
        if (cleared != 1) {
            source.method_9226((class_2561)class_2561.method_43470((String)("Cleared " + cleared + " Items!")), true);
        } else {
            source.method_9226((class_2561)class_2561.method_43470((String)("Cleared " + cleared + " Item!")), true);
        }
        return 1;
    }

    private static int handlePlace(class_2168 source, Collection<class_3222> players) {
        int cleared = 0;
        for (class_3222 player : players) {
            PlacementHandler.placeCarried(player);
            ++cleared;
        }
        if (cleared != 1) {
            source.method_9226((class_2561)class_2561.method_43470((String)("Placed " + cleared + " Items!")), true);
        } else {
            source.method_9226((class_2561)class_2561.method_43470((String)("Placed " + cleared + " Item!")), true);
        }
        return 1;
    }

    private static void log(class_2168 source, String toLog) {
        source.method_9226((class_2561)class_2561.method_43470((String)toLog), true);
        Constants.LOG.info(toLog);
    }
}

