/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.shader.compute;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL43;
import org.lwjgl.system.MemoryUtil;
import team.lodestar.lodestone.systems.rendering.IBufferObject;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderSystem;
import team.lodestar.lodestone.systems.rendering.shader.compute.SystemDetails;

public class ShaderStorageBufferObject
implements IBufferObject {
    private int bufferId;
    private final Usage usage;
    private final int bindingIndex;
    private FloatBuffer floatBuffer;

    public ShaderStorageBufferObject(Usage usage, int bindingIndex) {
        this(usage, bindingIndex, GL43.glGenBuffers());
    }

    public ShaderStorageBufferObject(Usage usage, int bindingIndex, int bufferId) {
        this.usage = usage;
        this.bindingIndex = bindingIndex;
        this.bufferId = bufferId;
        LodestoneRenderSystem.glBindBuffer((int)37074, (int)this.bufferId);
        LodestoneRenderSystem.bindBufferBase(37074, bindingIndex, this.bufferId);
        this.registerBufferObject();
    }

    public void upload(FloatBuffer floatBuffer) {
        int size = floatBuffer.remaining();
        if (floatBuffer.remaining() > SystemDetails.getMaxShaderStorageBlockSize()) {
            throw new RuntimeException("Buffer size exceeds maximum shader storage block size");
        }
        LodestoneRenderSystem.glBindBuffer((int)37074, (int)this.bufferId);
        GL43.glBufferData((int)37074, (FloatBuffer)floatBuffer, (int)this.usage.getGlEnum());
        LodestoneRenderSystem.glBindBuffer((int)37074, (int)0);
        this.floatBuffer = floatBuffer;
    }

    public static void unbind() {
        LodestoneRenderSystem.glBindBuffer((int)37074, (int)0);
    }

    public int getId() {
        return this.bufferId;
    }

    public int getBindingIndex() {
        return this.bindingIndex;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public FloatBuffer getFloatBuffer() {
        return this.floatBuffer;
    }

    public String toString() {
        return "ShaderStorageBufferObject{bufferId=" + this.bufferId + ", usage=" + String.valueOf((Object)this.usage) + ", bindingIndex=" + this.bindingIndex + "}";
    }

    @Override
    public void destroy() {
        if (this.bufferId != 0) {
            GL43.glDeleteProgram((int)this.bufferId);
        }
        if (this.floatBuffer != null) {
            MemoryUtil.memFree((Buffer)this.floatBuffer);
        }
    }

    public static enum Usage {
        STREAM_DRAW(35040),
        STREAM_READ(35041),
        STREAM_COPY(35042),
        STATIC_DRAW(35044),
        STATIC_READ(35045),
        STATIC_COPY(35046),
        DYNAMIC_DRAW(35048),
        DYNAMIC_READ(35049),
        DYNAMIC_COPY(35050);

        private final int glEnum;

        private Usage(int glEnum) {
            this.glEnum = glEnum;
        }

        public int getGlEnum() {
            return this.glEnum;
        }
    }
}

