/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.shader.compute;

import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.LodestoneLib;

public class ComputePreprocessor
extends GlslPreprocessor {
    private static Pattern concatPattern = Pattern.compile("\\$\\{([^}]+)}");
    private static Pattern localSizePattern = Pattern.compile("(local_size_)([xyz])( *= *)([0-9.]+)");
    public static final ComputePreprocessor INSTANCE = new ComputePreprocessor();

    public int[] getLocalSize(String shaderData) {
        int[] localSize = new int[]{-1, -1, -1};
        localSizePattern.matcher(shaderData).results().forEach(matchResult -> {
            int i = matchResult.group(2).charAt(0) - 120;
            if (i < 0 || i > 2) {
                LodestoneLib.LOGGER.error("Invalid local size direction found: " + matchResult.group(2).charAt(0));
                return;
            }
            localSize[i] = Integer.parseInt(matchResult.group(4));
        });
        return localSize;
    }

    public List<String> process(String shaderData) {
        return super.process(shaderData);
    }

    @Nullable
    public String applyImport(boolean pUseFullPath, String pDirectory) {
        ResourceLocation resourcelocation = ResourceLocation.parse((String)pDirectory);
        ResourceLocation resourcelocation1 = ResourceLocation.fromNamespaceAndPath((String)resourcelocation.getNamespace(), (String)("shaders/include/" + resourcelocation.getPath()));
        try {
            Resource resource1 = (Resource)Minecraft.getInstance().getResourceManager().getResource(resourcelocation1).orElseThrow();
            return IOUtils.toString((InputStream)resource1.open(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ioexception) {
            LodestoneLib.LOGGER.error("Could not open GLSL import {}: {}", (Object)pDirectory, (Object)ioexception.getMessage());
            return "#error " + ioexception.getMessage();
        }
    }
}

