/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.rendeertype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.ShaderInstance;

public class ShaderUniformHandler {
    public final ConcurrentHashMap<String, Float[]> uniformChanges = new ConcurrentHashMap();
    public static final ShaderUniformHandler DEPTH_FADE = new ShaderUniformHandler().withDepthFade().lock();
    public static final ShaderUniformHandler LUMITRANSPARENT = new ShaderUniformHandler().withLumiTransparency().lock();
    public static final ShaderUniformHandler LUMITRANSPARENT_DEPTH_FADE = new ShaderUniformHandler().withLumiTransparency().withDepthFade().lock();
    private boolean locked;

    public ShaderUniformHandler withLumiTransparency() {
        return this.modifyUniform("LumiTransparency", 1.0f);
    }

    public ShaderUniformHandler withDepthFade() {
        return this.modifyUniform("DepthFade", 1.5f);
    }

    public ShaderUniformHandler withDepthFade(float value) {
        return this.modifyUniform("DepthFade", value);
    }

    public ShaderUniformHandler modifyUniform(String uniformName, float ... values) {
        if (this.locked || values == null || values.length == 0) {
            return this;
        }
        Float[] newValues = new Float[values.length];
        for (int i = 0; i < values.length; ++i) {
            newValues[i] = Float.valueOf(values[i]);
        }
        this.uniformChanges.put(uniformName, newValues);
        return this;
    }

    public void updateShaderData(ShaderInstance instance) {
        for (Map.Entry<String, Float[]> uniformChange : this.uniformChanges.entrySet()) {
            instance.safeGetUniform(uniformChange.getKey()).set(this.toPrimitive(uniformChange.getValue()));
        }
    }

    private float[] toPrimitive(Float[] boxed) {
        float[] result = new float[boxed.length];
        for (int i = 0; i < boxed.length; ++i) {
            result[i] = boxed[i].floatValue();
        }
        return result;
    }

    public ShaderUniformHandler lock() {
        this.locked = true;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShaderUniformHandler that = (ShaderUniformHandler)o;
        if (this.uniformChanges.size() != that.uniformChanges.size()) {
            return false;
        }
        for (Map.Entry<String, Float[]> entry : this.uniformChanges.entrySet()) {
            Object[] otherValues = that.uniformChanges.get(entry.getKey());
            if (otherValues == null || otherValues.length != entry.getValue().length) {
                return false;
            }
            boolean isSame = Arrays.equals((Object[])entry.getValue(), otherValues);
            if (isSame) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        ArrayList<Map.Entry<String, Float[]>> entries = new ArrayList<Map.Entry<String, Float[]>>(this.uniformChanges.entrySet());
        entries.sort(Map.Entry.comparingByKey());
        for (Map.Entry entry : entries) {
            int keyHash = ((String)entry.getKey()).hashCode();
            int valueHash = Arrays.hashCode((Object[])entry.getValue());
            result = 31 * result + (keyHash ^ valueHash);
        }
        return result;
    }
}

