/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.rendeertype;

import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.resources.ResourceLocation;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.rendeertype.ComplexRenderTypeToken;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class RenderTypeToken {
    private static final HashMap<ResourceLocation, RenderTypeToken> CACHED_TEXTURE_TOKENS = new HashMap();
    private static final HashMap<RenderStateShard.TextureStateShard, RenderTypeToken> CACHED_STATE_TOKENS = new HashMap();
    private final UUID identifier;
    private final ResourceLocation texture;

    protected RenderTypeToken(RenderStateShard.TextureStateShard texture) {
        this((ResourceLocation)texture.cutoutTexture().orElseThrow());
    }

    protected RenderTypeToken(ResourceLocation texture) {
        this(UUID.randomUUID(), texture);
    }

    public RenderTypeToken(UUID identifier, ResourceLocation texture) {
        this.identifier = identifier;
        this.texture = texture;
    }

    public static RenderTypeToken createToken(ResourceLocation texture) {
        return CACHED_TEXTURE_TOKENS.computeIfAbsent(texture, RenderTypeToken::new);
    }

    public static RenderTypeToken createToken(RenderStateShard.TextureStateShard texture) {
        return CACHED_STATE_TOKENS.computeIfAbsent(texture, RenderTypeToken::new);
    }

    protected ComplexRenderTypeToken addUniformHandler(ShaderUniformHandler uniformHandler) {
        return new ComplexRenderTypeToken(this).addUniformHandler(uniformHandler);
    }

    protected ComplexRenderTypeToken addModifier(Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> modifier) {
        return new ComplexRenderTypeToken(this).addModifier(modifier);
    }

    protected RenderTypeToken unique() {
        return new RenderTypeToken(this.identifier, this.texture);
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public String toString() {
        return "RenderTypeToken{identifier=" + String.valueOf(this.identifier) + ", texture=" + String.valueOf(this.texture) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderTypeToken that = (RenderTypeToken)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.texture, that.texture);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.texture);
    }
}

