/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.rendeertype;

import java.util.Objects;
import java.util.function.Consumer;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeProvider;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class LodestoneRenderTypeBuilder {
    private final RenderTypeProvider provider;
    private RenderTypeToken token;
    private ShaderUniformHandler uniformHandler;
    private Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> modifier;

    public LodestoneRenderTypeBuilder(RenderTypeProvider provider, RenderTypeToken token) {
        this.provider = provider;
        this.token = token;
    }

    public LodestoneRenderTypeBuilder withUniformHandler(Consumer<ShaderUniformHandler> modifier) {
        if (this.uniformHandler != null) {
            modifier.accept(this.uniformHandler);
        } else {
            this.uniformHandler = new ShaderUniformHandler();
            modifier.accept(this.uniformHandler);
        }
        return this.withUniformHandler(this.uniformHandler);
    }

    public LodestoneRenderTypeBuilder withUniformHandler(ShaderUniformHandler uniformHandler) {
        this.uniformHandler = uniformHandler;
        this.token = this.token.addUniformHandler(uniformHandler);
        return this;
    }

    public LodestoneRenderTypeBuilder withModifier(Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> modifier) {
        this.modifier = modifier;
        this.token = this.token.addModifier(modifier);
        return this;
    }

    public LodestoneRenderType getRenderType() {
        return this.provider.createRenderType(this.token, this);
    }

    public RenderTypeProvider getProvider() {
        return this.provider;
    }

    public RenderTypeToken getToken() {
        return this.token;
    }

    public ShaderUniformHandler getUniformHandler() {
        return this.uniformHandler;
    }

    public Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> getModifier() {
        return this.modifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LodestoneRenderTypeBuilder that = (LodestoneRenderTypeBuilder)o;
        return Objects.equals(this.token, that.token) && Objects.equals(this.uniformHandler, that.uniformHandler) && Objects.equals(this.modifier, that.modifier);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.uniformHandler, this.modifier);
    }
}

