/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.cube;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public record CubeVertexData(Vector3f[] bottomVertices, Vector3f[] topVertices, List<Vector3f[]> offsetMap) {
    public static CubeVertexData makeCubePositions(float scale) {
        return CubeVertexData.makeCubePositions(scale, scale);
    }

    public static CubeVertexData makeCubePositions(float xScale, float yScale) {
        float xOffset = xScale / 2.0f;
        float yOffset = yScale / 2.0f;
        return CubeVertexData.makeCubePositions(-xOffset, xOffset, -yOffset, yOffset);
    }

    public static CubeVertexData makeCubePositions(float xStart, float xEnd, float yStart, float yEnd) {
        Vector3f[] bottomVertices = new Vector3f[]{new Vector3f(xStart, yStart, xStart), new Vector3f(xStart, yStart, xEnd), new Vector3f(xEnd, yStart, xEnd), new Vector3f(xEnd, yStart, xStart)};
        Vector3f[] topVertices = new Vector3f[]{new Vector3f(xStart, yEnd, xStart), new Vector3f(xStart, yEnd, xEnd), new Vector3f(xEnd, yEnd, xEnd), new Vector3f(xEnd, yEnd, xStart)};
        ArrayList<Vector3f[]> offsetMap = new ArrayList<Vector3f[]>();
        for (int i = 0; i < 4; ++i) {
            int index = (i * 3 + 3) % 4;
            offsetMap.add(new Vector3f[]{bottomVertices[index % 4], bottomVertices[(index + 1) % 4], topVertices[(index + 1) % 4], topVertices[index % 4]});
        }
        return new CubeVertexData(bottomVertices, topVertices, offsetMap);
    }

    public Vector3f[] getVerticesByDirection(Direction direction) {
        if (direction.equals((Object)Direction.UP)) {
            return this.topVertices;
        }
        if (direction.equals((Object)Direction.DOWN)) {
            return this.bottomVertices;
        }
        return this.getVerticesByIndex(direction.get2DDataValue());
    }

    public Vector3f[] getVerticesByIndex(int index) {
        return this.offsetMap.get(index);
    }

    public CubeVertexData applyWobble(float sineOffset, float strength) {
        return this.applyWobble(sineOffset, sineOffset, strength);
    }

    public CubeVertexData applyWobble(float bottomSineOffset, float topSineOffset, float strength) {
        return this.applyWobble(this.bottomVertices, bottomSineOffset, strength).applyWobble(this.topVertices, topSineOffset, strength);
    }

    public CubeVertexData applyWobble(Vector3f[] offsets, float sineOffset, float strength) {
        float offset = sineOffset;
        for (Vector3f vector3f : offsets) {
            double time = (double)((float)Minecraft.getInstance().level.getGameTime() / 40.0f) % Math.PI * 2.0;
            float sine = Mth.sin((float)((float)(time + (double)offset * Math.PI * 2.0))) * strength;
            vector3f.add(sine, -sine, sine);
            offset += 0.25f;
        }
        return this;
    }

    public CubeVertexData scale(float scale) {
        return this.scale(scale, scale);
    }

    public CubeVertexData scale(float width, float height) {
        return this.scale(width, height, width);
    }

    public CubeVertexData scale(float x, float y, float z) {
        for (int i = 0; i < this.bottomVertices.length; ++i) {
            this.bottomVertices[i].mul(x, y, z);
            this.topVertices[i].mul(x, y, z);
        }
        return this;
    }

    public CubeVertexData offset(float x, float y, float z) {
        for (int i = 0; i < this.bottomVertices.length; ++i) {
            this.bottomVertices[i].add(x, y, z);
            this.topVertices[i].add(x, y, z);
        }
        return this;
    }
}

