/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.buffer;

import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.SequencedMap;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;

public class LodestoneBufferSource
extends MultiBufferSource.BufferSource {
    protected final Supplier<ByteBufferBuilder> bufferSupplier;
    private final Collection<RenderType> additives = new HashSet<RenderType>();
    private final Collection<RenderType> nonAdditives = new HashSet<RenderType>();

    protected LodestoneBufferSource() {
        this(() -> new ByteBufferBuilder(786432), new LinkedHashMap<RenderType, ByteBufferBuilder>());
    }

    protected LodestoneBufferSource(Supplier<ByteBufferBuilder> bufferSupplier, SequencedMap<RenderType, ByteBufferBuilder> fixedBuffers) {
        super(bufferSupplier.get(), fixedBuffers);
        this.bufferSupplier = bufferSupplier;
    }

    public void endBatches(boolean additives) {
        Collection<RenderType> renderTypes = additives ? this.getAdditives() : this.getNonAdditives();
        for (RenderType type : renderTypes) {
            this.endBatch(type);
        }
    }

    @NotNull
    public VertexConsumer getBuffer(@NotNull RenderType renderType) {
        if (!this.fixedBuffers.containsKey(renderType)) {
            this.fixedBuffers.put(renderType, this.bufferSupplier.get());
            if (renderType instanceof LodestoneRenderType) {
                LodestoneRenderType lodestoneRenderType = (LodestoneRenderType)renderType;
                Collection<RenderType> group = lodestoneRenderType.isAdditive() ? this.additives : this.nonAdditives;
                group.add(renderType);
            }
        }
        return super.getBuffer(renderType);
    }

    public void endBatch(@NotNull RenderType renderType) {
        LodestoneRenderHandler.updateUniforms(renderType);
        super.endBatch(renderType);
        LodestoneRenderHandler.resetUniforms(renderType);
    }

    public Collection<RenderType> getAdditives() {
        return this.additives;
    }

    public Collection<RenderType> getNonAdditives() {
        return this.nonAdditives;
    }
}

