/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.helpers.RenderHelper;
import team.lodestar.lodestone.systems.rendering.buffer.LodestoneRenderLayer;
import team.lodestar.lodestone.systems.rendering.cube.CubeVertexData;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.trail.TrailPoint;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointRenderData;

public class VFXBuilders {
    public static final HashMap<VertexFormatElement, VertexConsumerActor> CONSUMER_INFO_MAP = new HashMap();

    public static Vector3f normal(PoseStack stack) {
        return VFXBuilders.normal(stack.last().normal());
    }

    public static Vector3f normal(Matrix3f transform) {
        return new Vector3f(0.0f, 1.0f, 0.0f).mul((Matrix3fc)transform);
    }

    public static ScreenVFXBuilder createScreen() {
        return new ScreenVFXBuilder();
    }

    public static WorldVFXBuilder createWorld() {
        return new WorldVFXBuilder();
    }

    static {
        CONSUMER_INFO_MAP.put(VertexFormatElement.POSITION, (consumer, pose, builder, normal, x, y, z, u, v) -> {
            if (pose == null) {
                consumer.addVertex(x, y, z);
                return;
            }
            consumer.addVertex(pose, x, y, z);
        });
        CONSUMER_INFO_MAP.put(VertexFormatElement.NORMAL, (consumer, pose, builder, normal, x, y, z, u, v) -> {
            if (normal == null) {
                return;
            }
            if (pose == null) {
                consumer.setNormal(normal.x, normal.y, normal.z);
                return;
            }
            consumer.setNormal(pose, normal.x, normal.y, normal.z);
        });
        CONSUMER_INFO_MAP.put(VertexFormatElement.COLOR, (consumer, pose, builder, normal, x, y, z, u, v) -> consumer.setColor(builder.r, builder.g, builder.b, builder.a));
        CONSUMER_INFO_MAP.put(VertexFormatElement.UV0, (consumer, pose, builder, normal, x, y, z, u, v) -> consumer.setUv(u, v));
        CONSUMER_INFO_MAP.put(VertexFormatElement.UV2, (consumer, pose, builder, normal, x, y, z, u, v) -> consumer.setLight(builder.light));
    }

    public static class ScreenVFXBuilder
    extends AbstractVFXBuilder {
        float x0 = 0.0f;
        float y0 = 0.0f;
        float x1 = 1.0f;
        float y1 = 1.0f;
        int zLevel;
        Supplier<ShaderInstance> shader;
        ResourceLocation texture;
        Tesselator tesselator = Tesselator.getInstance();

        @Override
        public ScreenVFXBuilder setColor(int rgba) {
            return (ScreenVFXBuilder)super.setColor(rgba);
        }

        @Override
        public ScreenVFXBuilder setColor(Color color) {
            return (ScreenVFXBuilder)super.setColor(color);
        }

        @Override
        public ScreenVFXBuilder setColor(Color color, int a) {
            return (ScreenVFXBuilder)super.setColor(color, a);
        }

        @Override
        public ScreenVFXBuilder setColor(Color color, float a) {
            return (ScreenVFXBuilder)super.setColor(color, a);
        }

        @Override
        public ScreenVFXBuilder setColor(int r, int g, int b, int a) {
            return (ScreenVFXBuilder)super.setColor(r, g, b, a);
        }

        @Override
        public ScreenVFXBuilder setColor(float r, float g, float b, float a) {
            return (ScreenVFXBuilder)super.setColor(r, g, b, a);
        }

        @Override
        public ScreenVFXBuilder setColor(int r, int g, int b) {
            return (ScreenVFXBuilder)super.setColor(r, g, b);
        }

        @Override
        public ScreenVFXBuilder setColor(float r, float g, float b) {
            return (ScreenVFXBuilder)super.setColor(r, g, b);
        }

        @Override
        public ScreenVFXBuilder multiplyColor(float scalar) {
            return (ScreenVFXBuilder)super.multiplyColor(scalar);
        }

        @Override
        public ScreenVFXBuilder multiplyColor(float r, float g, float b) {
            return (ScreenVFXBuilder)super.multiplyColor(r, g, b);
        }

        @Override
        public ScreenVFXBuilder setAlpha(int a) {
            return (ScreenVFXBuilder)super.setAlpha(a);
        }

        @Override
        public ScreenVFXBuilder setAlpha(float a) {
            return (ScreenVFXBuilder)super.setAlpha(a);
        }

        @Override
        public ScreenVFXBuilder setUVWithWidth(float u, float v, float width, float height, float canvasSize) {
            return (ScreenVFXBuilder)super.setUVWithWidth(u, v, width, height, canvasSize);
        }

        @Override
        public ScreenVFXBuilder setUVWithWidth(float u, float v, float width, float height, float canvasSizeX, float canvasSizeY) {
            return (ScreenVFXBuilder)super.setUVWithWidth(u, v, width, height, canvasSizeX, canvasSizeY);
        }

        @Override
        public ScreenVFXBuilder setUVWithWidth(float u, float v, float width, float height) {
            return (ScreenVFXBuilder)super.setUVWithWidth(u, v, width, height);
        }

        @Override
        public ScreenVFXBuilder setUV(float u0, float v0, float u1, float v1, float canvasSize) {
            return (ScreenVFXBuilder)super.setUV(u0, v0, u1, v1, canvasSize);
        }

        @Override
        public ScreenVFXBuilder setUV(float u0, float v0, float u1, float v1, float canvasSizeX, float canvasSizeY) {
            return (ScreenVFXBuilder)super.setUV(u0, v0, u1, v1, canvasSizeX, canvasSizeY);
        }

        @Override
        public ScreenVFXBuilder setUV(float u0, float v0, float u1, float v1) {
            return (ScreenVFXBuilder)super.setUV(u0, v0, u1, v1);
        }

        @Override
        public ScreenVFXBuilder setFormat(VertexFormat format) {
            return (ScreenVFXBuilder)super.setFormat(format);
        }

        @Override
        public ScreenVFXBuilder setVertexSupplier(VertexConsumerActor supplier) {
            return (ScreenVFXBuilder)super.setVertexSupplier(supplier);
        }

        @Override
        public ScreenVFXBuilder setFormatRaw(VertexFormat format) {
            return (ScreenVFXBuilder)super.setFormatRaw(format);
        }

        public ScreenVFXBuilder setShader(Supplier<ShaderInstance> shader) {
            this.shader = shader;
            return this.updateVertexFormat();
        }

        public ScreenVFXBuilder setShader(ShaderInstance shader) {
            this.shader = () -> shader;
            return this.updateVertexFormat();
        }

        public Supplier<ShaderInstance> getShader() {
            if (this.shader == null) {
                this.setShader(GameRenderer::getPositionTexShader);
            }
            return this.shader;
        }

        public ScreenVFXBuilder setShaderTexture(ResourceLocation texture) {
            this.texture = texture;
            return this;
        }

        public final ScreenVFXBuilder updateVertexFormat() {
            return this.setFormat(this.getShader().get().getVertexFormat());
        }

        @Override
        public ScreenVFXBuilder setLight(int light) {
            this.light = light;
            return this;
        }

        public ScreenVFXBuilder setPositionWithWidth(float x, float y, float width, float height) {
            return this.setPosition(x, y, x + width, y + height);
        }

        public ScreenVFXBuilder setPosition(float x0, float y0, float x1, float y1) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            return this;
        }

        public ScreenVFXBuilder setZLevel(int z) {
            this.zLevel = z;
            return this;
        }

        public ScreenVFXBuilder blit(PoseStack stack) {
            RenderSystem.setShader(this.getShader());
            if (this.texture != null) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            }
            BufferBuilder bufferBuilder = this.tesselator.begin(this.mode, this.format);
            this.supplier.placeVertex((VertexConsumer)bufferBuilder, stack, (AbstractVFXBuilder)this, this.x0, this.y1, (float)this.zLevel, this.u0, this.v1);
            this.supplier.placeVertex((VertexConsumer)bufferBuilder, stack, (AbstractVFXBuilder)this, this.x1, this.y1, (float)this.zLevel, this.u1, this.v1);
            this.supplier.placeVertex((VertexConsumer)bufferBuilder, stack, (AbstractVFXBuilder)this, this.x1, this.y0, (float)this.zLevel, this.u1, this.v0);
            this.supplier.placeVertex((VertexConsumer)bufferBuilder, stack, (AbstractVFXBuilder)this, this.x0, this.y0, (float)this.zLevel, this.u0, this.v0);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            return this;
        }
    }

    public static class WorldVFXBuilder
    extends AbstractVFXBuilder {
        private final Minecraft minecraft = Minecraft.getInstance();
        @Nonnull
        protected LodestoneRenderLayer renderLayer = LodestoneRenderHandler.DEFERRED_RENDER;
        protected MultiBufferSource bufferSource;
        protected RenderType renderType;
        protected VertexConsumer vertexConsumer;
        protected boolean usePartialTicks;
        protected float partialTicks;

        @Override
        public WorldVFXBuilder setColor(int rgba) {
            return (WorldVFXBuilder)super.setColor(rgba);
        }

        @Override
        public WorldVFXBuilder setColor(Color color) {
            return (WorldVFXBuilder)super.setColor(color);
        }

        @Override
        public WorldVFXBuilder setColor(Color color, int a) {
            return (WorldVFXBuilder)super.setColor(color, a);
        }

        @Override
        public WorldVFXBuilder setColor(Color color, float a) {
            return (WorldVFXBuilder)super.setColor(color, a);
        }

        @Override
        public WorldVFXBuilder setColor(int r, int g, int b, int a) {
            return (WorldVFXBuilder)super.setColor(r, g, b, a);
        }

        @Override
        public WorldVFXBuilder setColor(float r, float g, float b, float a) {
            return (WorldVFXBuilder)super.setColor(r, g, b, a);
        }

        @Override
        public WorldVFXBuilder setColor(int r, int g, int b) {
            return (WorldVFXBuilder)super.setColor(r, g, b);
        }

        @Override
        public WorldVFXBuilder setColor(float r, float g, float b) {
            return (WorldVFXBuilder)super.setColor(r, g, b);
        }

        @Override
        public WorldVFXBuilder multiplyColor(float scalar) {
            return (WorldVFXBuilder)super.multiplyColor(scalar);
        }

        @Override
        public WorldVFXBuilder multiplyColor(float r, float g, float b) {
            return (WorldVFXBuilder)super.multiplyColor(r, g, b);
        }

        @Override
        public WorldVFXBuilder setAlpha(int a) {
            return (WorldVFXBuilder)super.setAlpha(a);
        }

        @Override
        public WorldVFXBuilder setAlpha(float a) {
            return (WorldVFXBuilder)super.setAlpha(a);
        }

        @Override
        public WorldVFXBuilder setLight(int light) {
            return (WorldVFXBuilder)super.setLight(light);
        }

        @Override
        public WorldVFXBuilder setUVWithWidth(float u, float v, float width, float height, float canvasSize) {
            return (WorldVFXBuilder)super.setUVWithWidth(u, v, width, height, canvasSize);
        }

        @Override
        public WorldVFXBuilder setUVWithWidth(float u, float v, float width, float height, float canvasSizeX, float canvasSizeY) {
            return (WorldVFXBuilder)super.setUVWithWidth(u, v, width, height, canvasSizeX, canvasSizeY);
        }

        @Override
        public WorldVFXBuilder setUVWithWidth(float u, float v, float width, float height) {
            return (WorldVFXBuilder)super.setUVWithWidth(u, v, width, height);
        }

        @Override
        public WorldVFXBuilder setUV(float u0, float v0, float u1, float v1, float canvasSize) {
            return (WorldVFXBuilder)super.setUV(u0, v0, u1, v1, canvasSize);
        }

        @Override
        public WorldVFXBuilder setUV(float u0, float v0, float u1, float v1, float canvasSizeX, float canvasSizeY) {
            return (WorldVFXBuilder)super.setUV(u0, v0, u1, v1, canvasSizeX, canvasSizeY);
        }

        @Override
        public WorldVFXBuilder setUV(float u0, float v0, float u1, float v1) {
            return (WorldVFXBuilder)super.setUV(u0, v0, u1, v1);
        }

        @Override
        public WorldVFXBuilder setFormatRaw(VertexFormat format) {
            return (WorldVFXBuilder)super.setFormatRaw(format);
        }

        @Override
        public WorldVFXBuilder setVertexSupplier(VertexConsumerActor supplier) {
            return (WorldVFXBuilder)super.setVertexSupplier(supplier);
        }

        @Override
        public WorldVFXBuilder setFormat(VertexFormat format) {
            return (WorldVFXBuilder)super.setFormat(format);
        }

        public WorldVFXBuilder setRenderType(LodestoneRenderTypeBuilder renderType) {
            return this.setRenderType(renderType.getRenderType());
        }

        public WorldVFXBuilder setRenderType(RenderType renderType) {
            return this.setRenderTypeRaw(renderType).setFormat(renderType.format()).setVertexConsumer(this.getBufferSource().getBuffer(renderType));
        }

        public WorldVFXBuilder setRenderTypeRaw(RenderType renderType) {
            this.renderType = renderType;
            return this;
        }

        public WorldVFXBuilder setVertexConsumer(VertexConsumer vertexConsumer) {
            this.vertexConsumer = vertexConsumer;
            return this;
        }

        public VertexConsumer getVertexConsumer() {
            if (this.vertexConsumer == null) {
                this.setVertexConsumer(this.getBufferSource().getBuffer(this.getRenderType()));
            }
            return this.vertexConsumer;
        }

        public WorldVFXBuilder replaceBufferSource(LodestoneRenderLayer renderLayer) {
            this.renderLayer = renderLayer;
            this.vertexConsumer = null;
            return this;
        }

        public WorldVFXBuilder replaceBufferSource(MultiBufferSource bufferSource) {
            this.bufferSource = bufferSource;
            this.vertexConsumer = null;
            return this;
        }

        protected MultiBufferSource getBufferSource() {
            if (this.bufferSource == null) {
                this.replaceBufferSource((MultiBufferSource)this.renderLayer.getTarget());
            }
            return this.bufferSource;
        }

        public WorldVFXBuilder usePartialTicks(float partialTicks) {
            this.usePartialTicks = true;
            this.partialTicks = partialTicks;
            return this;
        }

        public WorldVFXBuilder setLightLevel(BlockPos pos) {
            ClientLevel level = this.minecraft.level;
            int light = level.hasChunkAt(pos) ? LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos) : 0;
            return this.setLight(light);
        }

        protected RenderType getRenderType() {
            return this.renderType;
        }

        protected VertexFormat getFormat() {
            return this.format;
        }

        public VertexConsumerActor getSupplier() {
            return this.supplier;
        }

        protected Vec3 getCameraPosition() {
            return this.minecraft.getBlockEntityRenderDispatcher().camera.getPosition();
        }

        protected Matrix4f getOffsetViewMatrix() {
            Matrix4f pose = new Matrix4f((Matrix4fc)LodestoneRenderHandler.MODEL_VIEW);
            Vector3f cameraPosition = this.getCameraPosition().toVector3f();
            return pose.translate(-cameraPosition.x, -cameraPosition.y, -cameraPosition.z);
        }

        public WorldVFXBuilder renderBeam(@Nullable PoseStack.Pose last, BlockPos start, BlockPos end, float width) {
            return this.renderBeam(last, start.getCenter(), end.getCenter(), width, this.getCameraPosition());
        }

        public WorldVFXBuilder renderBeam(@Nullable PoseStack.Pose last, Vec3 start, Vec3 end, float width) {
            return this.renderBeam(last, start, end, width, this.getCameraPosition());
        }

        public WorldVFXBuilder renderBeam(@Nullable PoseStack.Pose last, Vec3 start, Vec3 end, float width, Consumer<WorldVFXBuilder> consumer) {
            return this.renderBeam(last, start, end, width, this.getCameraPosition(), consumer);
        }

        public WorldVFXBuilder renderBeam(@Nullable PoseStack.Pose last, Vec3 start, Vec3 end, float width, Vec3 cameraPosition) {
            return this.renderBeam(last, start, end, width, cameraPosition, builder -> {});
        }

        public WorldVFXBuilder renderBeam(@Nullable PoseStack.Pose last, Vec3 start, Vec3 end, float width, Vec3 cameraPosition, Consumer<WorldVFXBuilder> consumer) {
            Vec3 delta = end.subtract(start);
            Vec3 normal = start.subtract(cameraPosition).cross(delta).normalize().multiply((double)(width / 2.0f), (double)(width / 2.0f), (double)(width / 2.0f));
            Vec3[] positions = new Vec3[]{start.subtract(normal), start.add(normal), end.add(normal), end.subtract(normal)};
            this.supplier.placeVertex(this.getVertexConsumer(), last, (AbstractVFXBuilder)this, (float)positions[0].x, (float)positions[0].y, (float)positions[0].z, this.u0, this.v1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, (AbstractVFXBuilder)this, (float)positions[1].x, (float)positions[1].y, (float)positions[1].z, this.u1, this.v1);
            consumer.accept(this);
            this.supplier.placeVertex(this.getVertexConsumer(), last, (AbstractVFXBuilder)this, (float)positions[2].x, (float)positions[2].y, (float)positions[2].z, this.u1, this.v0);
            this.supplier.placeVertex(this.getVertexConsumer(), last, (AbstractVFXBuilder)this, (float)positions[3].x, (float)positions[3].y, (float)positions[3].z, this.u0, this.v0);
            return this;
        }

        public WorldVFXBuilder renderTrail(TrailPointBuilder trailPoints, float width) {
            return this.renderTrail(trailPoints, f -> Float.valueOf(width), f -> {});
        }

        public WorldVFXBuilder renderTrail(TrailPointBuilder trailPoints, Function<Float, Float> widthFunc) {
            return this.renderTrail(trailPoints, widthFunc, f -> {});
        }

        public WorldVFXBuilder renderTrail(TrailPointBuilder builder, Function<Float, Float> widthFunc, Consumer<Float> vfxOperator) {
            List<TrailPoint> trailPoints = builder.getTrailPoints();
            if (trailPoints.size() < 2) {
                return this;
            }
            Matrix4f pose = this.getOffsetViewMatrix();
            List<Vector4f> positions = this.usePartialTicks ? builder.build(pose, this.partialTicks) : builder.build(pose);
            positions.getLast().set((Vector4fc)TrailPoint.getMatrixPosition(builder.getOrigin(), pose));
            int count = trailPoints.size() - 1;
            float increment = 1.0f / (float)count;
            TrailPointRenderData[] renderData = new TrailPointRenderData[trailPoints.size()];
            for (int i = 1; i < count; ++i) {
                float width = widthFunc.apply(Float.valueOf(increment * (float)i)).floatValue();
                Vector4f previous = positions.get(i - 1);
                Vector4f current = positions.get(i);
                Vector4f next = positions.get(i + 1);
                renderData[i] = new TrailPointRenderData(current, RenderHelper.perpendicularTrailPoints(previous, next, width));
            }
            Vector4f first = positions.get(0);
            Vector4f second = positions.get(1);
            Vector4f secondToLast = positions.get(count - 1);
            Vector4f last = positions.get(count);
            renderData[0] = new TrailPointRenderData(first, RenderHelper.perpendicularTrailPoints(first, second, widthFunc.apply(Float.valueOf(0.0f)).floatValue()));
            renderData[count] = new TrailPointRenderData(last, RenderHelper.perpendicularTrailPoints(secondToLast, last, widthFunc.apply(Float.valueOf(1.0f)).floatValue()));
            return this.renderConnectedPoints(renderData, this.u0, this.v0, this.u1, this.v1, vfxOperator);
        }

        public WorldVFXBuilder renderConnectedPoints(TrailPointRenderData[] points, float u0, float v0, float u1, float v1, Consumer<Float> vfxOperator) {
            this.replaceBufferSource((MultiBufferSource)this.renderLayer.getTrailTarget());
            int count = points.length - 1;
            float increment = 1.0f / (float)count;
            vfxOperator.accept(Float.valueOf(0.0f));
            points[0].renderStart(this.getVertexConsumer(), this, u0, v0, u1);
            for (int i = 1; i < count; ++i) {
                float current = Mth.lerp((float)((float)i * increment), (float)v0, (float)v1);
                vfxOperator.accept(Float.valueOf(current));
                points[i].renderMid(this.getVertexConsumer(), this, u0, current, u1, current);
            }
            vfxOperator.accept(Float.valueOf(1.0f));
            points[count].renderEnd(this.getVertexConsumer(), this, u0, u1, v1);
            return this;
        }

        public WorldVFXBuilder renderCube(PoseStack poseStack, CubeVertexData cubeVertexData) {
            Vector3f[] topVertices = cubeVertexData.topVertices();
            Vector3f[] bottomVertices = cubeVertexData.bottomVertices();
            List<Vector3f[]> offsetMap = cubeVertexData.offsetMap();
            for (Vector3f[] offsets : offsetMap) {
                this.renderQuad(poseStack, offsets);
            }
            this.renderQuad(poseStack, new Vector3f[]{bottomVertices[3], bottomVertices[2], bottomVertices[1], bottomVertices[0]});
            this.renderQuad(poseStack, topVertices);
            return this;
        }

        public WorldVFXBuilder renderCubeSides(PoseStack poseStack, CubeVertexData cubeVertexData, Direction ... directions) {
            for (Direction direction : directions) {
                this.renderCubeSide(poseStack, cubeVertexData, direction);
            }
            return this;
        }

        public WorldVFXBuilder renderCubeSide(PoseStack poseStack, CubeVertexData cubeVertexData, Direction direction) {
            Vector3f[] vertices = cubeVertexData.getVerticesByDirection(direction);
            this.renderQuad(poseStack, vertices);
            return this;
        }

        public WorldVFXBuilder renderQuad(PoseStack stack) {
            return this.renderQuad(stack, 1.0f);
        }

        public WorldVFXBuilder renderQuad(PoseStack stack, float size) {
            return this.renderQuad(stack, size, size);
        }

        public WorldVFXBuilder renderQuad(PoseStack stack, float width, float height) {
            Vector3f[] positions = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f)};
            return this.renderQuad(stack, positions, width, height);
        }

        public WorldVFXBuilder renderQuad(PoseStack stack, Vector3f[] positions, float size) {
            return this.renderQuad(stack, positions, size, size);
        }

        public WorldVFXBuilder renderQuad(PoseStack stack, Vector3f[] positions, float width, float height) {
            for (Vector3f position : positions) {
                position.mul(width, height, width);
            }
            return this.renderQuad(stack, positions);
        }

        public WorldVFXBuilder renderQuad(PoseStack stack, Vector3f[] positions) {
            this.supplier.placeVertex(this.getVertexConsumer(), stack, (AbstractVFXBuilder)this, positions[0].x(), positions[0].y(), positions[0].z(), this.u0, this.v1);
            this.supplier.placeVertex(this.getVertexConsumer(), stack, (AbstractVFXBuilder)this, positions[1].x(), positions[1].y(), positions[1].z(), this.u1, this.v1);
            this.supplier.placeVertex(this.getVertexConsumer(), stack, (AbstractVFXBuilder)this, positions[2].x(), positions[2].y(), positions[2].z(), this.u1, this.v0);
            this.supplier.placeVertex(this.getVertexConsumer(), stack, (AbstractVFXBuilder)this, positions[3].x(), positions[3].y(), positions[3].z(), this.u0, this.v0);
            return this;
        }

        public WorldVFXBuilder renderSphere(PoseStack stack, float radius, int longs, int lats) {
            float startU = this.u0;
            float startV = this.v0;
            float endU = (float)Math.PI * 2 * this.u1;
            float endV = (float)Math.PI * this.v1;
            float stepU = (endU - startU) / (float)longs;
            float stepV = (endV - startV) / (float)lats;
            for (int i = 0; i < longs; ++i) {
                for (int j = 0; j < lats; ++j) {
                    float u = (float)i * stepU + startU;
                    float v = (float)j * stepV + startV;
                    float un = i + 1 == longs ? endU : (float)(i + 1) * stepU + startU;
                    float vn = j + 1 == lats ? endV : (float)(j + 1) * stepV + startV;
                    Vector3f p0 = RenderHelper.parametricSphere(u, v, radius);
                    Vector3f p1 = RenderHelper.parametricSphere(u, vn, radius);
                    Vector3f p2 = RenderHelper.parametricSphere(un, v, radius);
                    Vector3f p3 = RenderHelper.parametricSphere(un, vn, radius);
                    float textureU = u / endU * radius;
                    float textureV = v / endV * radius;
                    float textureUN = un / endU * radius;
                    float textureVN = vn / endV * radius;
                    this.supplier.placeVertex(this.getVertexConsumer(), stack, (AbstractVFXBuilder)this, p0.x(), p0.y(), p0.z(), textureU, textureV);
                    this.supplier.placeVertex(this.getVertexConsumer(), stack, (AbstractVFXBuilder)this, p2.x(), p2.y(), p2.z(), textureUN, textureV);
                    this.supplier.placeVertex(this.getVertexConsumer(), stack, (AbstractVFXBuilder)this, p1.x(), p1.y(), p1.z(), textureU, textureVN);
                    this.supplier.placeVertex(this.getVertexConsumer(), stack, (AbstractVFXBuilder)this, p3.x(), p3.y(), p3.z(), textureUN, textureVN);
                    this.supplier.placeVertex(this.getVertexConsumer(), stack, (AbstractVFXBuilder)this, p1.x(), p1.y(), p1.z(), textureU, textureVN);
                    this.supplier.placeVertex(this.getVertexConsumer(), stack, (AbstractVFXBuilder)this, p2.x(), p2.y(), p2.z(), textureUN, textureV);
                }
            }
            return this;
        }

        public WorldVFXBuilder renderTorus(PoseStack stack, float majorRadius, float minorRadius, int majorSegments, int minorSegments) {
            float TAU = (float)Math.PI * 2;
            for (int i = 0; i < majorSegments; ++i) {
                float u0n = (float)i / (float)majorSegments;
                float u1n = (float)(i + 1) / (float)majorSegments;
                float u0 = u0n * TAU;
                float u1 = u1n * TAU;
                for (int j = 0; j < minorSegments; ++j) {
                    float v0n = (float)j / (float)minorSegments;
                    float v1n = (float)(j + 1) / (float)minorSegments;
                    float v0 = v0n * TAU;
                    float v1 = v1n * TAU;
                    Vector3f p0 = RenderHelper.parametricTorus(u0, v0, majorRadius, minorRadius);
                    Vector3f p1 = RenderHelper.parametricTorus(u0, v1, majorRadius, minorRadius);
                    Vector3f p2 = RenderHelper.parametricTorus(u1, v0, majorRadius, minorRadius);
                    Vector3f p3 = RenderHelper.parametricTorus(u1, v1, majorRadius, minorRadius);
                    this.supplier.placeVertex(this.getVertexConsumer(), stack, (AbstractVFXBuilder)this, p0.x(), p0.y(), p0.z(), u0n, v0n);
                    this.supplier.placeVertex(this.getVertexConsumer(), stack, (AbstractVFXBuilder)this, p2.x(), p2.y(), p2.z(), u1n, v0n);
                    this.supplier.placeVertex(this.getVertexConsumer(), stack, (AbstractVFXBuilder)this, p1.x(), p1.y(), p1.z(), u0n, v1n);
                    this.supplier.placeVertex(this.getVertexConsumer(), stack, (AbstractVFXBuilder)this, p3.x(), p3.y(), p3.z(), u1n, v1n);
                    this.supplier.placeVertex(this.getVertexConsumer(), stack, (AbstractVFXBuilder)this, p1.x(), p1.y(), p1.z(), u0n, v1n);
                    this.supplier.placeVertex(this.getVertexConsumer(), stack, (AbstractVFXBuilder)this, p2.x(), p2.y(), p2.z(), u1n, v0n);
                }
            }
            return this;
        }
    }

    public static abstract class AbstractVFXBuilder {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        int light = 0xF000F0;
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;
        VertexFormat format;
        VertexConsumerActor supplier;
        VertexFormat.Mode mode = VertexFormat.Mode.QUADS;

        public AbstractVFXBuilder setFormat(VertexFormat format) {
            ImmutableList elements = ImmutableList.copyOf((Collection)format.getElements());
            return this.setFormatRaw(format).setVertexSupplier((consumer, last, builder, normal, x, y, z, u, v) -> {
                for (VertexFormatElement element : elements) {
                    CONSUMER_INFO_MAP.get(element).placeVertex(consumer, last, this, normal, x, y, z, u, v);
                }
            });
        }

        public AbstractVFXBuilder setVertexSupplier(VertexConsumerActor supplier) {
            this.supplier = supplier;
            return this;
        }

        public AbstractVFXBuilder setFormatRaw(VertexFormat format) {
            this.format = format;
            return this;
        }

        public AbstractVFXBuilder setColor(int rgba) {
            return this.setColor(rgba >> 16 & 0xFF, rgba >> 8 & 0xFF, rgba & 0xFF, rgba >> 24 & 0xFF);
        }

        public AbstractVFXBuilder setColor(Color color) {
            return this.setColor(color.getRed(), color.getGreen(), color.getBlue());
        }

        public AbstractVFXBuilder setColor(Color color, int a) {
            return this.setColor(color).setAlpha(a);
        }

        public AbstractVFXBuilder setColor(Color color, float a) {
            return this.setColor(color).setAlpha(a);
        }

        public AbstractVFXBuilder setColor(int r, int g, int b, int a) {
            return this.setColor(r, g, b).setAlpha(a);
        }

        public AbstractVFXBuilder setColor(float r, float g, float b, float a) {
            return this.setColor(r, g, b).setAlpha(a);
        }

        public AbstractVFXBuilder setColor(int r, int g, int b) {
            return this.setColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
        }

        public AbstractVFXBuilder setColor(float r, float g, float b) {
            this.r = r;
            this.g = g;
            this.b = b;
            return this;
        }

        public AbstractVFXBuilder multiplyColor(float scalar) {
            return this.multiplyColor(scalar, scalar, scalar);
        }

        public AbstractVFXBuilder multiplyColor(float r, float g, float b) {
            return this.setColor(this.r * r, this.g * g, this.b * b);
        }

        public AbstractVFXBuilder setAlpha(int a) {
            return this.setAlpha((float)a / 255.0f);
        }

        public AbstractVFXBuilder setAlpha(float a) {
            this.a = a;
            return this;
        }

        public AbstractVFXBuilder setLight(int light) {
            this.light = light;
            return this;
        }

        public AbstractVFXBuilder setUVWithWidth(float u, float v, float width, float height, float canvasSize) {
            return this.setUVWithWidth(u, v, width, height, canvasSize, canvasSize);
        }

        public AbstractVFXBuilder setUVWithWidth(float u, float v, float width, float height, float canvasSizeX, float canvasSizeY) {
            return this.setUVWithWidth(u / canvasSizeX, v / canvasSizeY, width / canvasSizeX, height / canvasSizeY);
        }

        public AbstractVFXBuilder setUVWithWidth(float u, float v, float width, float height) {
            this.u0 = u;
            this.v0 = v;
            this.u1 = u + width;
            this.v1 = v + height;
            return this;
        }

        public AbstractVFXBuilder setUV(float u0, float v0, float u1, float v1, float canvasSize) {
            return this.setUV(u0, v0, u1, v1, canvasSize, canvasSize);
        }

        public AbstractVFXBuilder setUV(float u0, float v0, float u1, float v1, float canvasSizeX, float canvasSizeY) {
            return this.setUV(u0 / canvasSizeX, v0 / canvasSizeY, u1 / canvasSizeX, v1 / canvasSizeY);
        }

        public AbstractVFXBuilder setUV(float u0, float v0, float u1, float v1) {
            this.u0 = u0;
            this.v0 = v0;
            this.u1 = u1;
            this.v1 = v1;
            return this;
        }
    }

    public static interface VertexConsumerActor {
        public void placeVertex(VertexConsumer var1, PoseStack.Pose var2, AbstractVFXBuilder var3, Vector3f var4, float var5, float var6, float var7, float var8, float var9);

        default public void placeVertex(VertexConsumer consumer, PoseStack stack, AbstractVFXBuilder builder, float x, float y, float z, float u, float v) {
            Vector3f normal = VFXBuilders.normal(stack);
            this.placeVertex(consumer, stack.last(), builder, normal, x, y, z, u, v);
        }

        default public void placeVertex(VertexConsumer consumer, PoseStack.Pose pose, AbstractVFXBuilder builder, float x, float y, float z, float u, float v) {
            this.placeVertex(consumer, pose, builder, null, x, y, z, u, v);
        }

        default public void placeVertex(VertexConsumer consumer, AbstractVFXBuilder builder, Vector3f normal, float x, float y, float z, float u, float v) {
            this.placeVertex(consumer, null, builder, normal, x, y, z, u, v);
        }

        default public void placeVertex(VertexConsumer consumer, AbstractVFXBuilder builder, float x, float y, float z, float u, float v) {
            this.placeVertex(consumer, builder, null, x, y, z, u, v);
        }
    }
}

