/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Optional;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import team.lodestar.lodestone.systems.rendering.StateShards;

public class LodestoneRenderType
extends RenderType {
    public final RenderType.CompositeState state;
    private final RenderType outline;
    private final boolean isOutline;
    private final boolean isAdditive;

    public LodestoneRenderType(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, RenderType.CompositeState pState) {
        super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, () -> pState.states.forEach(RenderStateShard::setupRenderState), () -> pState.states.forEach(RenderStateShard::clearRenderState));
        this.state = pState;
        this.outline = pState.outlineProperty == RenderType.OutlineProperty.AFFECTS_OUTLINE ? (RenderType)pState.textureState.cutoutTexture().map(p_173270_ -> (RenderType)RenderType.CompositeRenderType.OUTLINE.apply(p_173270_, pState.cullState)).orElse(null) : null;
        this.isOutline = pState.outlineProperty == RenderType.OutlineProperty.IS_OUTLINE;
        this.isAdditive = LodestoneRenderType.isAdditive(this);
    }

    public static boolean isAdditive(LodestoneRenderType renderType) {
        return renderType.state.transparencyState.equals(StateShards.ADDITIVE_TRANSPARENCY);
    }

    public Optional<RenderType> outline() {
        return Optional.ofNullable(this.outline);
    }

    public boolean isOutline() {
        return this.isOutline;
    }

    public String toString() {
        return "RenderType[" + this.name + ":" + String.valueOf(this.state) + "]";
    }

    public void draw(MeshData meshData) {
        RenderSystem.depthMask((boolean)this.state.writeMaskState.writeDepth);
        this.setupRenderState();
        BufferUploader.drawWithShader((MeshData)meshData);
        this.clearRenderState();
    }

    public boolean isAdditive() {
        return this.isAdditive;
    }
}

