/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeProvider;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class LodestoneBufferWrapper
implements MultiBufferSource {
    public final RenderTypeProvider provider;
    public final MultiBufferSource buffer;

    public LodestoneBufferWrapper(RenderTypeProvider provider, MultiBufferSource buffer) {
        this.provider = provider;
        this.buffer = buffer;
    }

    public VertexConsumer getBuffer(RenderType renderType) {
        if (renderType instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType composite = (RenderType.CompositeRenderType)renderType;
            RenderStateShard.EmptyTextureStateShard emptyTextureStateShard = composite.state.textureState;
            if (emptyTextureStateShard instanceof RenderStateShard.TextureStateShard) {
                RenderStateShard.TextureStateShard textureState = (RenderStateShard.TextureStateShard)emptyTextureStateShard;
                LodestoneRenderTypeBuilder key = this.provider.apply(RenderTypeToken.createToken(textureState));
                return this.buffer.getBuffer((RenderType)key.getRenderType());
            }
        }
        return this.buffer.getBuffer(renderType);
    }
}

