/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.world.behaviors;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;

public class BillboardParticleBehavior
implements LodestoneParticleBehavior {
    public static final BillboardParticleBehavior INSTANCE = new BillboardParticleBehavior();

    protected BillboardParticleBehavior() {
    }

    @Override
    public void render(LodestoneWorldParticle particle, VertexConsumer consumer, Camera camera, float partialTicks) {
        Quaternionf quaternionf;
        Vec3 vec3 = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTicks, (double)particle.getXOld(), (double)particle.getX()) - vec3.x());
        float y = (float)(Mth.lerp((double)partialTicks, (double)particle.getYOld(), (double)particle.getY()) - vec3.y());
        float z = (float)(Mth.lerp((double)partialTicks, (double)particle.getZOld(), (double)particle.getZ()) - vec3.z());
        if (particle.getRoll() == 0.0f) {
            quaternionf = camera.rotation();
        } else {
            quaternionf = new Quaternionf((Quaternionfc)camera.rotation());
            quaternionf.rotateZ(Mth.lerp((float)partialTicks, (float)particle.getORoll(), (float)particle.getRoll()));
        }
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float width = particle.getQuadSize(partialTicks);
        float length = particle.getQuadLength(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.mul(width, length, 1.0f);
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.add(x, y, z);
        }
        float u0 = particle.getU0();
        float u1 = particle.getU1();
        float v0 = particle.getV0();
        float v1 = particle.getV1();
        float red = particle.getRed();
        float green = particle.getGreen();
        float blue = particle.getBlue();
        float alpha = particle.getAlpha();
        int j = particle.getLightColor(partialTicks);
        consumer.addVertex(avector3f[0].x(), avector3f[0].y(), avector3f[0].z()).setUv(u1, v1).setColor(red, green, blue, alpha).setLight(j);
        consumer.addVertex(avector3f[1].x(), avector3f[1].y(), avector3f[1].z()).setUv(u1, v0).setColor(red, green, blue, alpha).setLight(j);
        consumer.addVertex(avector3f[2].x(), avector3f[2].y(), avector3f[2].z()).setUv(u0, v0).setColor(red, green, blue, alpha).setLight(j);
        consumer.addVertex(avector3f[3].x(), avector3f[3].y(), avector3f[3].z()).setUv(u0, v1).setColor(red, green, blue, alpha).setLight(j);
    }
}

