/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.data.color;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataBuilder;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;

public class ColorParticleData
implements ColorParticleDataWrapper {
    public static final Codec<ColorParticleData> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)Codec.FLOAT.fieldOf("r1").forGetter(data -> Float.valueOf(data.r1)), (App)Codec.FLOAT.fieldOf("g1").forGetter(data -> Float.valueOf(data.g1)), (App)Codec.FLOAT.fieldOf("b1").forGetter(data -> Float.valueOf(data.b1)), (App)Codec.FLOAT.fieldOf("r2").forGetter(data -> Float.valueOf(data.r2)), (App)Codec.FLOAT.fieldOf("g2").forGetter(data -> Float.valueOf(data.g2)), (App)Codec.FLOAT.fieldOf("b2").forGetter(data -> Float.valueOf(data.b2)), (App)Codec.FLOAT.fieldOf("colorCoefficient").forGetter(data -> Float.valueOf(data.colorCoefficient)), (App)Easing.CODEC.fieldOf("colorCurveEasing").forGetter(data -> data.colorCurve), (App)Codec.FLOAT.fieldOf("coefficientMultiplier").forGetter(data -> Float.valueOf(data.coefficientMultiplier))).apply((Applicative)instance, ColorParticleData::new));
    protected final float r1;
    protected final float g1;
    protected final float b1;
    protected final float r2;
    protected final float g2;
    protected final float b2;
    protected final Color startingColor;
    protected final Color endingColor;
    protected final float colorCoefficient;
    protected final Easing colorCurve;
    protected float coefficientMultiplier = 1.0f;
    protected boolean locked;

    protected ColorParticleData(float r1, float g1, float b1, float r2, float g2, float b2, float colorCoefficient, Easing colorCurve, float coefficientMultiplier) {
        this(r1, g1, b1, r2, g2, b2, colorCoefficient, colorCurve);
        this.coefficientMultiplier = coefficientMultiplier;
    }

    protected ColorParticleData(float r1, float g1, float b1, float r2, float g2, float b2, float colorCoefficient, Easing colorCurve) {
        this.r1 = r1;
        this.g1 = g1;
        this.b1 = b1;
        this.r2 = r2;
        this.g2 = g2;
        this.b2 = b2;
        this.startingColor = new Color(r1, g1, b1);
        this.endingColor = new Color(r2, g2, b2);
        this.colorCoefficient = colorCoefficient;
        this.colorCurve = colorCurve;
    }

    @Override
    public ColorParticleData unwrap() {
        return this;
    }

    public ColorParticleData lock() {
        this.locked = true;
        return this;
    }

    public Color getStartingColor() {
        return this.startingColor;
    }

    public Color getEndingColor() {
        return this.endingColor;
    }

    public float getColorCoefficient() {
        return this.colorCoefficient;
    }

    public Easing getColorCurve() {
        return this.colorCurve;
    }

    public ColorParticleData multiplyCoefficient(float coefficientMultiplier) {
        if (!this.locked) {
            this.coefficientMultiplier *= coefficientMultiplier;
        }
        return this;
    }

    public ColorParticleData overrideCoefficientMultiplier(float coefficientMultiplier) {
        if (!this.locked) {
            this.coefficientMultiplier = coefficientMultiplier;
        }
        return this;
    }

    public void rgbToHsv(float[] hsv1, float[] hsv2) {
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, this.r1)), (int)(255.0f * Math.min(1.0f, this.g1)), (int)(255.0f * Math.min(1.0f, this.b1)), hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, this.r2)), (int)(255.0f * Math.min(1.0f, this.g2)), (int)(255.0f * Math.min(1.0f, this.b2)), hsv2);
    }

    public float getProgress(float age, float lifetime) {
        return Mth.clamp((float)(age * this.colorCoefficient * this.coefficientMultiplier / lifetime), (float)0.0f, (float)1.0f);
    }

    public ColorParticleDataBuilder invert() {
        return ColorParticleData.create(this.r2, this.g2, this.b2, this.r1, this.g1, this.b1).setCoefficient(this.colorCoefficient).setEasing(this.colorCurve);
    }

    public ColorParticleDataBuilder copy() {
        return ColorParticleData.create(this.r1, this.g1, this.b1, this.r2, this.g2, this.b2).setCoefficient(this.colorCoefficient).setEasing(this.colorCurve);
    }

    public static ColorParticleDataBuilder create(float r1, float g1, float b1, float r2, float g2, float b2) {
        return new ColorParticleDataBuilder(r1, g1, b1, r2, g2, b2);
    }

    public static ColorParticleDataBuilder create(float r, float g, float b) {
        return new ColorParticleDataBuilder(r, g, b, r, g, b);
    }

    public static ColorParticleDataBuilder create(Color start, Color end) {
        return ColorParticleData.create((float)start.getRed() / 255.0f, (float)start.getGreen() / 255.0f, (float)start.getBlue() / 255.0f, (float)end.getRed() / 255.0f, (float)end.getGreen() / 255.0f, (float)end.getBlue() / 255.0f);
    }

    public static ColorParticleDataBuilder create(Color color) {
        return ColorParticleData.create((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
    }

    public static ColorParticleData createGrayParticleColor(RandomSource random) {
        int brightness = (int)(255.0f * RandomHelper.randomBetween(random, 0.6f, 1.0f));
        Color color = new Color(brightness, brightness, brightness);
        return ColorParticleData.create(color, color.darker()).setEasing(Easing.SINE_IN_OUT).build();
    }
}

