/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.registry.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.registry.client.LodestoneShaders;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.StateShards;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeData;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeProvider;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;
import team.lodestar.lodestone.systems.rendering.shader.ShaderHolder;

public class LodestoneRenderTypes
extends RenderStateShard {
    public static final Runnable TRANSPARENT_FUNCTION = () -> RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    public static final Runnable ADDITIVE_FUNCTION = () -> RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    public static final RenderStateShard.EmptyTextureStateShard NO_TEXTURE = RenderStateShard.NO_TEXTURE;
    public static final RenderStateShard.LightmapStateShard LIGHTMAP = RenderStateShard.LIGHTMAP;
    public static final RenderStateShard.LightmapStateShard NO_LIGHTMAP = RenderStateShard.NO_LIGHTMAP;
    public static final RenderStateShard.CullStateShard CULL = RenderStateShard.CULL;
    public static final RenderStateShard.CullStateShard NO_CULL = RenderStateShard.NO_CULL;
    public static final RenderStateShard.WriteMaskStateShard COLOR_DEPTH_WRITE = RenderStateShard.COLOR_DEPTH_WRITE;
    public static final RenderStateShard.WriteMaskStateShard COLOR_WRITE = RenderStateShard.COLOR_WRITE;
    public static final HashMap<Pair<Object, LodestoneRenderType>, LodestoneRenderType> COPIES = new HashMap();
    public static final Function<RenderTypeData, LodestoneRenderType> GENERIC = RenderTypeData::createRenderType;
    private static Consumer<LodestoneCompositeStateBuilder> MODIFIER;
    public static final LodestoneRenderType ADDITIVE_PARTICLE;
    public static final LodestoneRenderType ADDITIVE_BLOCK_PARTICLE;
    public static final LodestoneRenderType ADDITIVE_BLOCK;
    public static final LodestoneRenderType ADDITIVE_SOLID;
    public static final LodestoneRenderType TRANSPARENT_PARTICLE;
    public static final LodestoneRenderType TRANSPARENT_BLOCK_PARTICLE;
    public static final LodestoneRenderType TRANSPARENT_BLOCK;
    public static final LodestoneRenderType TRANSPARENT_SOLID;
    public static final LodestoneRenderType LUMITRANSPARENT_PARTICLE;
    public static final LodestoneRenderType LUMITRANSPARENT_BLOCK_PARTICLE;
    public static final LodestoneRenderType LUMITRANSPARENT_BLOCK;
    public static final LodestoneRenderType LUMITRANSPARENT_SOLID;
    public static final RenderTypeProvider TEXTURE;
    public static final RenderTypeProvider CUTOUT_TEXTURE;
    public static final RenderTypeProvider TEXTURE_FADE;
    public static final RenderTypeProvider TRANSPARENT_TEXT;
    public static final RenderTypeProvider ADDITIVE_TEXT;
    public static final RenderTypeProvider TRANSPARENT_TEXTURE;
    public static final RenderTypeProvider TRANSPARENT_DISTORTED_TEXTURE;
    public static final RenderTypeProvider TRANSPARENT_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider TRANSPARENT_TWO_SIDED_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider TRANSPARENT_ROUNDED_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider TRANSPARENT_SCROLLING_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider TRANSPARENT_NINE_SLICE_TEXTURE;
    public static final RenderTypeProvider TRANSPARENT_DISTORTED_NINE_SLICE_TEXTURE;
    public static final RenderTypeProvider ADDITIVE_TEXTURE;
    public static final RenderTypeProvider ADDITIVE_DISTORTED_TEXTURE;
    public static final RenderTypeProvider ADDITIVE_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider ADDITIVE_TWO_SIDED_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider ADDITIVE_ROUNDED_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider ADDITIVE_SCROLLING_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider ADDITIVE_NINE_SLICE_TEXTURE;
    public static final RenderTypeProvider ADDITIVE_DISTORTED_NINE_SLICE_TEXTURE;
    public static final RenderTypeProvider DEBUG_SDF;

    public LodestoneRenderTypes(String p_110161_, Runnable p_110162_, Runnable p_110163_) {
        super(p_110161_, p_110162_, p_110163_);
    }

    public static LodestoneRenderType createTransparentRenderType(String name, RenderTypeToken token, ShaderHolder shader) {
        return LodestoneRenderTypes.createGenericRenderType(name, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(token, StateShards.NORMAL_TRANSPARENCY, shader, CULL, LIGHTMAP, COLOR_WRITE));
    }

    public static LodestoneRenderType createAdditiveRenderType(String name, RenderTypeToken token, ShaderHolder shader) {
        return LodestoneRenderTypes.createGenericRenderType(name, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(token, StateShards.ADDITIVE_TRANSPARENCY, shader, CULL, LIGHTMAP, COLOR_WRITE));
    }

    public static LodestoneRenderType createGenericRenderType(String name, VertexFormat format, VertexFormat.Mode mode, LodestoneCompositeStateBuilder builder) {
        return LodestoneRenderTypes.createGenericRenderType(name, format, mode, builder, null);
    }

    public static LodestoneRenderType createGenericRenderType(String name, VertexFormat format, VertexFormat.Mode mode, LodestoneCompositeStateBuilder builder, ShaderUniformHandler handler) {
        if (MODIFIER != null) {
            MODIFIER.accept(builder);
        }
        LodestoneRenderType type = new LodestoneRenderType(name, format, builder.modeOverride != null ? builder.modeOverride : mode, 256, false, true, builder.createCompositeState(true));
        if (handler != null) {
            LodestoneRenderTypes.addUniformChanges(type, handler);
        }
        MODIFIER = null;
        return type;
    }

    public static LodestoneRenderType createCopy(LodestoneRenderTypeBuilder type) {
        return LodestoneRenderTypes.createCopy(type.getRenderType());
    }

    public static LodestoneRenderType createCopy(String newName, LodestoneRenderTypeBuilder type) {
        return LodestoneRenderTypes.createCopy(newName, type.getRenderType());
    }

    public static LodestoneRenderType createCopy(LodestoneRenderType type) {
        return GENERIC.apply(new RenderTypeData(type));
    }

    public static LodestoneRenderType createCopy(String newName, LodestoneRenderType type) {
        return GENERIC.apply(new RenderTypeData(newName, type));
    }

    public static LodestoneRenderType createCachedCopy(Object index, LodestoneRenderTypeBuilder type) {
        return LodestoneRenderTypes.createCachedCopy(index, type.getRenderType());
    }

    public static LodestoneRenderType createCachedCopy(Object index, LodestoneRenderType type) {
        return COPIES.computeIfAbsent((Pair<Object, LodestoneRenderType>)Pair.of((Object)index, (Object)((Object)type)), p -> GENERIC.apply(new RenderTypeData(type)));
    }

    public static LodestoneRenderType addUniformChanges(LodestoneRenderType type, ShaderUniformHandler handler) {
        LodestoneRenderHandler.DEFERRED_UNIFORMS.put(type, handler);
        return type;
    }

    public static void addRenderTypeModifier(Consumer<LodestoneCompositeStateBuilder> modifier) {
        MODIFIER = modifier;
    }

    public static LodestoneCompositeStateBuilder builder(Object ... objects) {
        return LodestoneRenderTypes.builder().setStateShards(objects);
    }

    public static LodestoneCompositeStateBuilder builder() {
        return new LodestoneCompositeStateBuilder();
    }

    static {
        ADDITIVE_PARTICLE = LodestoneRenderTypes.createGenericRenderType("additive_particle", DefaultVertexFormat.PARTICLE, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(TextureAtlas.LOCATION_PARTICLES, StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.PARTICLE, NO_CULL, LIGHTMAP, COLOR_WRITE));
        ADDITIVE_BLOCK_PARTICLE = LodestoneRenderTypes.createGenericRenderType("additive_block_particle", DefaultVertexFormat.PARTICLE, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(TextureAtlas.LOCATION_BLOCKS, StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.PARTICLE, NO_CULL, LIGHTMAP, COLOR_WRITE));
        ADDITIVE_BLOCK = LodestoneRenderTypes.createGenericRenderType("additive_block", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(TextureAtlas.LOCATION_BLOCKS, StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXTURE, NO_CULL, LIGHTMAP, COLOR_WRITE));
        ADDITIVE_SOLID = LodestoneRenderTypes.createGenericRenderType("additive_solid", DefaultVertexFormat.POSITION_COLOR_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(StateShards.ADDITIVE_TRANSPARENCY, POSITION_COLOR_LIGHTMAP_SHADER, NO_CULL, LIGHTMAP, COLOR_WRITE));
        TRANSPARENT_PARTICLE = LodestoneRenderTypes.createGenericRenderType("transparent_particle", DefaultVertexFormat.PARTICLE, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(TextureAtlas.LOCATION_PARTICLES, StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.PARTICLE, NO_CULL, LIGHTMAP, COLOR_WRITE));
        TRANSPARENT_BLOCK_PARTICLE = LodestoneRenderTypes.createGenericRenderType("transparent_block_particle", DefaultVertexFormat.PARTICLE, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(TextureAtlas.LOCATION_BLOCKS, StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.PARTICLE, NO_CULL, LIGHTMAP, COLOR_WRITE));
        TRANSPARENT_BLOCK = LodestoneRenderTypes.createGenericRenderType("transparent_block", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(TextureAtlas.LOCATION_BLOCKS, StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXTURE, NO_CULL, LIGHTMAP, COLOR_WRITE));
        TRANSPARENT_SOLID = LodestoneRenderTypes.createGenericRenderType("transparent_solid", DefaultVertexFormat.POSITION_COLOR_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(StateShards.NORMAL_TRANSPARENCY, POSITION_COLOR_LIGHTMAP_SHADER, NO_CULL, LIGHTMAP, COLOR_WRITE));
        LUMITRANSPARENT_PARTICLE = LodestoneRenderTypes.addUniformChanges(LodestoneRenderTypes.createCopy("lodestone:lumitransparent_particle", TRANSPARENT_PARTICLE), ShaderUniformHandler.LUMITRANSPARENT);
        LUMITRANSPARENT_BLOCK_PARTICLE = LodestoneRenderTypes.addUniformChanges(LodestoneRenderTypes.createCopy("lodestone:lumitransparent_block_particle", TRANSPARENT_BLOCK_PARTICLE), ShaderUniformHandler.LUMITRANSPARENT);
        LUMITRANSPARENT_BLOCK = LodestoneRenderTypes.addUniformChanges(LodestoneRenderTypes.createCopy("lodestone:lumitransparent_block", TRANSPARENT_BLOCK), ShaderUniformHandler.LUMITRANSPARENT);
        LUMITRANSPARENT_SOLID = LodestoneRenderTypes.addUniformChanges(LodestoneRenderTypes.createCopy("lodestone:lumitransparent_solid", TRANSPARENT_SOLID), ShaderUniformHandler.LUMITRANSPARENT);
        TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("texture", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(token, StateShards.NO_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXTURE, CULL, LIGHTMAP)));
        CUTOUT_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("cutout_texture", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(token, StateShards.NO_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXTURE, CULL, LIGHTMAP)));
        TEXTURE_FADE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("texture_fade", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(token, StateShards.NO_TRANSPARENCY, LodestoneShaders.TEXTURE_FADE, CULL, LIGHTMAP)));
        TRANSPARENT_TEXT = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("transparent_text", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(token, StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXT, LIGHTMAP)));
        ADDITIVE_TEXT = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("additive_text", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(token, StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXT, LIGHTMAP, COLOR_WRITE)));
        TRANSPARENT_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createTransparentRenderType("transparent_texture", token, LodestoneShaders.LODESTONE_TEXTURE));
        TRANSPARENT_DISTORTED_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createTransparentRenderType("transparent_distorted_texture", token, LodestoneShaders.DISTORTED_TEXTURE));
        TRANSPARENT_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createTransparentRenderType("transparent_triangle_texture", token, LodestoneShaders.TRIANGLE_TEXTURE));
        TRANSPARENT_TWO_SIDED_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createTransparentRenderType("transparent_two_sided_triangle_texture", token, LodestoneShaders.TWO_SIDED_TRIANGLE_TEXTURE));
        TRANSPARENT_ROUNDED_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createTransparentRenderType("transparent_rounded_triangle_texture", token, LodestoneShaders.ROUNDED_TRIANGLE_TEXTURE));
        TRANSPARENT_SCROLLING_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createTransparentRenderType("transparent_scrolling_texture_triangle", token, LodestoneShaders.ROUNDED_TRIANGLE_TEXTURE));
        TRANSPARENT_NINE_SLICE_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createTransparentRenderType("transparent_nine_slice_texture", token, LodestoneShaders.NINE_SLICE));
        TRANSPARENT_DISTORTED_NINE_SLICE_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createTransparentRenderType("transparent_distorted_nine_slice_texture", token, LodestoneShaders.DISTORTED_NINE_SLICE_TEXTURE));
        ADDITIVE_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createAdditiveRenderType("additive_texture", token, LodestoneShaders.LODESTONE_TEXTURE));
        ADDITIVE_DISTORTED_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createAdditiveRenderType("additive_distorted_texture", token, LodestoneShaders.DISTORTED_TEXTURE));
        ADDITIVE_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createAdditiveRenderType("additive_triangle_texture", token, LodestoneShaders.TRIANGLE_TEXTURE));
        ADDITIVE_TWO_SIDED_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createAdditiveRenderType("additive_two_sided_triangle_texture", token, LodestoneShaders.TWO_SIDED_TRIANGLE_TEXTURE));
        ADDITIVE_ROUNDED_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createAdditiveRenderType("additive_rounded_triangle_texture", token, LodestoneShaders.ROUNDED_TRIANGLE_TEXTURE));
        ADDITIVE_SCROLLING_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createAdditiveRenderType("additive_scrolling_texture_triangle", token, LodestoneShaders.ROUNDED_TRIANGLE_TEXTURE));
        ADDITIVE_NINE_SLICE_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createAdditiveRenderType("additive_nine_slice_texture", token, LodestoneShaders.NINE_SLICE));
        ADDITIVE_DISTORTED_NINE_SLICE_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createAdditiveRenderType("additive_distorted_nine_slice_texture", token, LodestoneShaders.DISTORTED_NINE_SLICE_TEXTURE));
        DEBUG_SDF = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("debug_sdf", DefaultVertexFormat.POSITION, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(token, LodestoneShaders.DEBUG_SDF, CULL)));
    }

    public static class LodestoneCompositeStateBuilder
    extends RenderType.CompositeState.CompositeStateBuilder {
        protected VertexFormat.Mode modeOverride;

        LodestoneCompositeStateBuilder() {
        }

        public LodestoneCompositeStateBuilder replaceVertexFormat(VertexFormat.Mode mode) {
            this.modeOverride = mode;
            return this;
        }

        public LodestoneCompositeStateBuilder copyState(RenderType.CompositeState state) {
            for (RenderStateShard renderStateShard : state.states) {
                this.setStateShards(renderStateShard);
            }
            return this;
        }

        public LodestoneCompositeStateBuilder setStateShards(Object ... objects) {
            for (Object object : objects) {
                if (object instanceof ResourceLocation) {
                    ResourceLocation texture = (ResourceLocation)object;
                    this.setTextureState(texture);
                    continue;
                }
                if (object instanceof RenderTypeToken) {
                    RenderTypeToken token = (RenderTypeToken)object;
                    this.setTextureState(token);
                    continue;
                }
                if (object instanceof RenderStateShard.EmptyTextureStateShard) {
                    RenderStateShard.EmptyTextureStateShard shard = (RenderStateShard.EmptyTextureStateShard)object;
                    this.setTextureState(shard);
                    continue;
                }
                if (object instanceof ShaderHolder) {
                    ShaderHolder shaderHolder = (ShaderHolder)object;
                    this.setShaderState(shaderHolder);
                    continue;
                }
                if (object instanceof RenderStateShard.ShaderStateShard) {
                    RenderStateShard.ShaderStateShard shard = (RenderStateShard.ShaderStateShard)object;
                    this.setShaderState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.TransparencyStateShard) {
                    RenderStateShard.TransparencyStateShard shard = (RenderStateShard.TransparencyStateShard)object;
                    this.setTransparencyState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.DepthTestStateShard) {
                    RenderStateShard.DepthTestStateShard shard = (RenderStateShard.DepthTestStateShard)object;
                    this.setDepthTestState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.CullStateShard) {
                    RenderStateShard.CullStateShard shard = (RenderStateShard.CullStateShard)object;
                    this.setCullState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.LightmapStateShard) {
                    RenderStateShard.LightmapStateShard shard = (RenderStateShard.LightmapStateShard)object;
                    this.setLightmapState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.OverlayStateShard) {
                    RenderStateShard.OverlayStateShard shard = (RenderStateShard.OverlayStateShard)object;
                    this.setOverlayState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.LayeringStateShard) {
                    RenderStateShard.LayeringStateShard shard = (RenderStateShard.LayeringStateShard)object;
                    this.setLayeringState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.OutputStateShard) {
                    RenderStateShard.OutputStateShard shard = (RenderStateShard.OutputStateShard)object;
                    this.setOutputState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.TexturingStateShard) {
                    RenderStateShard.TexturingStateShard shard = (RenderStateShard.TexturingStateShard)object;
                    this.setTexturingState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.WriteMaskStateShard) {
                    RenderStateShard.WriteMaskStateShard shard = (RenderStateShard.WriteMaskStateShard)object;
                    this.setWriteMaskState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.LineStateShard) {
                    RenderStateShard.LineStateShard shard = (RenderStateShard.LineStateShard)object;
                    this.setLineState(shard);
                    continue;
                }
                if (!(object instanceof RenderStateShard.ColorLogicStateShard)) continue;
                RenderStateShard.ColorLogicStateShard shard = (RenderStateShard.ColorLogicStateShard)object;
                this.setColorLogicState(shard);
            }
            return this;
        }

        public LodestoneCompositeStateBuilder setTextureState(RenderTypeToken token) {
            return this.setTextureState(token.getTexture());
        }

        public LodestoneCompositeStateBuilder setTextureState(ResourceLocation texture) {
            return this.setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false));
        }

        public LodestoneCompositeStateBuilder setShaderState(ShaderHolder shaderHolder) {
            return this.setShaderState(shaderHolder.getShard());
        }

        public LodestoneCompositeStateBuilder setTextureState(RenderStateShard.EmptyTextureStateShard pTextureState) {
            return (LodestoneCompositeStateBuilder)super.setTextureState(pTextureState);
        }

        public LodestoneCompositeStateBuilder setShaderState(RenderStateShard.ShaderStateShard pShaderState) {
            return (LodestoneCompositeStateBuilder)super.setShaderState(pShaderState);
        }

        public LodestoneCompositeStateBuilder setTransparencyState(RenderStateShard.TransparencyStateShard pTransparencyState) {
            return (LodestoneCompositeStateBuilder)super.setTransparencyState(pTransparencyState);
        }

        public LodestoneCompositeStateBuilder setDepthTestState(RenderStateShard.DepthTestStateShard pDepthTestState) {
            return (LodestoneCompositeStateBuilder)super.setDepthTestState(pDepthTestState);
        }

        public LodestoneCompositeStateBuilder setCullState(RenderStateShard.CullStateShard pCullState) {
            return (LodestoneCompositeStateBuilder)super.setCullState(pCullState);
        }

        public LodestoneCompositeStateBuilder setLightmapState(RenderStateShard.LightmapStateShard pLightmapState) {
            return (LodestoneCompositeStateBuilder)super.setLightmapState(pLightmapState);
        }

        public LodestoneCompositeStateBuilder setOverlayState(RenderStateShard.OverlayStateShard pOverlayState) {
            return (LodestoneCompositeStateBuilder)super.setOverlayState(pOverlayState);
        }

        public LodestoneCompositeStateBuilder setLayeringState(RenderStateShard.LayeringStateShard pLayerState) {
            return (LodestoneCompositeStateBuilder)super.setLayeringState(pLayerState);
        }

        public LodestoneCompositeStateBuilder setOutputState(RenderStateShard.OutputStateShard pOutputState) {
            return (LodestoneCompositeStateBuilder)super.setOutputState(pOutputState);
        }

        public LodestoneCompositeStateBuilder setTexturingState(RenderStateShard.TexturingStateShard pTexturingState) {
            return (LodestoneCompositeStateBuilder)super.setTexturingState(pTexturingState);
        }

        public LodestoneCompositeStateBuilder setWriteMaskState(RenderStateShard.WriteMaskStateShard pWriteMaskState) {
            return (LodestoneCompositeStateBuilder)super.setWriteMaskState(pWriteMaskState);
        }

        public LodestoneCompositeStateBuilder setLineState(RenderStateShard.LineStateShard pLineState) {
            return (LodestoneCompositeStateBuilder)super.setLineState(pLineState);
        }
    }
}

