/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.registry.client;

import java.util.ArrayList;
import java.util.List;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.systems.model.obj.IndexedModel;
import team.lodestar.lodestone.systems.model.obj.ObjModel;
import team.lodestar.lodestone.systems.model.obj.lod.MultiLODModel;

@EventBusSubscriber(modid="lodestone", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class LodestoneOBJModels {
    public static List<ObjModel> OBJ_MODELS = new ArrayList<ObjModel>();
    public static List<MultiLODModel> LOD_MODELS = new ArrayList<MultiLODModel>();
    public static final ObjModel SUZANNE = LodestoneOBJModels.register(ObjModel.Builder.of(LodestoneLib.lodestonePath("suzanne")).build());

    public static ObjModel register(ObjModel objModel) {
        OBJ_MODELS.add(objModel);
        return objModel;
    }

    public static MultiLODModel register(MultiLODModel lodModel) {
        LOD_MODELS.add(lodModel);
        return lodModel;
    }

    public static void loadModels() {
        OBJ_MODELS.forEach(ObjModel::loadModel);
        LOD_MODELS.forEach(MultiLODModel::loadModel);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClientSetup(FMLClientSetupEvent event) {
        LodestoneOBJModels.loadModels();
    }

    public static void cleanup() {
        OBJ_MODELS.forEach(IndexedModel::cleanup);
        LOD_MODELS.forEach(IndexedModel::cleanup);
    }
}

