/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.network.screenshake;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import team.lodestar.lodestone.handlers.ScreenshakeHandler;
import team.lodestar.lodestone.helpers.ReflectionHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.network.OneSidedPayloadData;
import team.lodestar.lodestone.systems.screenshake.ScreenshakeInstance;

public class ScreenshakePayload
extends OneSidedPayloadData {
    public int duration;
    public float intensity1;
    public float intensity2;
    public float intensity3;
    public Easing intensityCurveStartEasing;
    public Easing intensityCurveEndEasing;
    public static final Codec<ScreenshakePayload> CODEC = RecordCodecBuilder.create(obj -> obj.group((App)Codec.INT.fieldOf("duration").forGetter(p -> p.duration), (App)Codec.FLOAT.fieldOf("intensity1").forGetter(p -> Float.valueOf(p.intensity1)), (App)Codec.FLOAT.fieldOf("intensity2").forGetter(p -> Float.valueOf(p.intensity2)), (App)Codec.FLOAT.fieldOf("intensity3").forGetter(p -> Float.valueOf(p.intensity3)), (App)Easing.CODEC.fieldOf("intensityCurveStartEasing").forGetter(p -> p.intensityCurveStartEasing), (App)Easing.CODEC.fieldOf("intensityCurveEndEasing").forGetter(p -> p.intensityCurveEndEasing)).apply((Applicative)obj, ScreenshakePayload::new));
    public static final StreamCodec<ByteBuf, ScreenshakePayload> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);

    public ScreenshakePayload(FriendlyByteBuf byteBuf) {
        ReflectionHelper.copyFields(this, (ScreenshakePayload)STREAM_CODEC.decode((Object)byteBuf), new String[0]);
    }

    public ScreenshakePayload(int duration, float intensity1, float intensity2, float intensity3, Easing intensityCurveStartEasing, Easing intensityCurveEndEasing) {
        this.duration = duration;
        this.intensity1 = intensity1;
        this.intensity2 = intensity2;
        this.intensity3 = intensity3;
        this.intensityCurveStartEasing = intensityCurveStartEasing;
        this.intensityCurveEndEasing = intensityCurveEndEasing;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(IPayloadContext context) {
        ScreenshakeHandler.addScreenshake(new ScreenshakeInstance(this.duration).setIntensity(this.intensity1, this.intensity2, this.intensity3).setEasing(this.intensityCurveStartEasing, this.intensityCurveEndEasing));
    }

    @Override
    public void serialize(FriendlyByteBuf byteBuf) {
        STREAM_CODEC.encode((Object)byteBuf, (Object)this);
    }
}

