/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import java.util.ArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import team.lodestar.lodestone.config.ClientConfig;
import team.lodestar.lodestone.systems.screenshake.ScreenshakeInstance;

public class ScreenshakeHandler {
    private static final ArrayList<ScreenshakeInstance> INSTANCES = new ArrayList();
    private static float intensity;

    public static void cameraSetup(Camera camera) {
        if ((double)intensity >= 0.1) {
            RandomSource random = Minecraft.getInstance().level.getRandom();
            float yawOffset = ScreenshakeHandler.randomizeOffset(random);
            float pitchOffset = ScreenshakeHandler.randomizeOffset(random);
            camera.setRotation(camera.getYRot() + yawOffset, camera.getXRot() + pitchOffset);
        }
    }

    public static void clientTick(Camera camera) {
        RandomSource random = Minecraft.getInstance().level.getRandom();
        double sum = Math.min(INSTANCES.stream().mapToDouble(s -> s.updateIntensity(camera, random)).sum(), ClientConfig.SCREENSHAKE_INTENSITY.getConfigValue());
        intensity = (float)Math.pow(sum, 3.0);
        INSTANCES.removeIf(i -> i.progress >= i.duration);
    }

    public static void addScreenshake(ScreenshakeInstance instance) {
        INSTANCES.add(instance);
    }

    public static float randomizeOffset(RandomSource random) {
        return Mth.nextFloat((RandomSource)random, (float)(-intensity * 2.0f), (float)(intensity * 2.0f));
    }
}

