/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.world;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.config.ClientConfig;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class LodestoneWorldParticle
extends TextureSheetParticle {
    public final ParticleRenderType renderType;
    public final LodestoneParticleBehavior behavior;
    public final RenderHandler.LodestoneRenderLayer renderLayer;
    public final ParticleEngine.MutableSpriteSet spriteSet;
    public final SimpleParticleOptions.ParticleSpritePicker spritePicker;
    public final ColorParticleData colorData;
    public final GenericParticleData transparencyData;
    public final GenericParticleData scaleData;
    @Nullable
    public final GenericParticleData lengthData;
    public final SpinParticleData spinData;
    public final Collection<Consumer<LodestoneWorldParticle>> tickActors;
    public final Collection<Consumer<LodestoneWorldParticle>> renderActors;
    public final int particleLight;
    public int lifeDelay;
    private float quadLength;
    float[] hsv1 = new float[3];
    float[] hsv2 = new float[3];

    public LodestoneWorldParticle(ClientLevel world, WorldParticleOptions options, ParticleEngine.MutableSpriteSet spriteSet, double x, double y, double z, double xd, double yd, double zd) {
        super(world, x, y, z);
        this.renderType = options.renderType;
        this.behavior = options.behavior;
        this.renderLayer = options.renderLayer;
        this.spriteSet = spriteSet;
        this.spritePicker = options.spritePicker;
        this.colorData = options.colorData;
        this.transparencyData = options.transparencyData;
        this.scaleData = options.scaleData;
        this.lengthData = options.lengthData != WorldParticleOptions.DEFAULT_GENERIC ? options.lengthData : null;
        this.spinData = options.spinData;
        this.tickActors = options.tickActors;
        this.renderActors = options.renderActors;
        this.particleLight = options.particleLight;
        this.roll = options.spinData.spinOffset + options.spinData.startingValue;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.setLifetime((Integer)options.lifetimeSupplier.get());
        this.lifeDelay = (Integer)options.lifeDelaySupplier.get();
        this.gravity = ((Float)options.gravityStrengthSupplier.get()).floatValue();
        this.friction = ((Float)options.frictionStrengthSupplier.get()).floatValue();
        this.hasPhysics = !options.noClip;
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, this.colorData.r1)), (int)(255.0f * Math.min(1.0f, this.colorData.g1)), (int)(255.0f * Math.min(1.0f, this.colorData.b1)), this.hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, this.colorData.r2)), (int)(255.0f * Math.min(1.0f, this.colorData.g2)), (int)(255.0f * Math.min(1.0f, this.colorData.b2)), this.hsv2);
        if (spriteSet != null) {
            if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.RANDOM_SPRITE)) {
                this.pickSprite((SpriteSet)spriteSet);
            } else if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.FIRST_INDEX) || this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.WITH_AGE)) {
                this.pickSprite(0);
            } else if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.LAST_INDEX)) {
                this.pickSprite(spriteSet.sprites.size() - 1);
            }
        }
        options.spawnActors.forEach(actor -> actor.accept(this));
        this.updateTraits();
    }

    public SimpleParticleOptions.ParticleSpritePicker getSpritePicker() {
        return this.spritePicker;
    }

    public VertexConsumer getVertexConsumer(VertexConsumer original) {
        ParticleRenderType particleRenderType;
        VertexConsumer consumerToUse = original;
        if (ClientConfig.DELAYED_PARTICLE_RENDERING.getConfigValue().booleanValue() && (particleRenderType = this.renderType) instanceof LodestoneWorldParticleRenderType) {
            LodestoneWorldParticleRenderType lodestoneRenderType = (LodestoneWorldParticleRenderType)particleRenderType;
            consumerToUse = this.renderLayer.getParticleTarget().getBuffer((RenderType)lodestoneRenderType.renderType);
        }
        return consumerToUse;
    }

    public void pickSprite(int spriteIndex) {
        if (spriteIndex < this.spriteSet.sprites.size() && spriteIndex >= 0) {
            this.setSprite((TextureAtlasSprite)this.spriteSet.sprites.get(spriteIndex));
        }
    }

    public void pickColor(float colorCoeff) {
        float h = Mth.rotLerp((float)colorCoeff, (float)(360.0f * this.hsv1[0]), (float)(360.0f * this.hsv2[0])) / 360.0f;
        float s = Mth.lerp((float)colorCoeff, (float)this.hsv1[1], (float)this.hsv2[1]);
        float v = Mth.lerp((float)colorCoeff, (float)this.hsv1[2], (float)this.hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)FastColor.ARGB32.red((int)packed) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)packed) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)packed) / 255.0f;
        this.setColor(r, g, b);
    }

    protected void updateTraits() {
        if ((this.scaleData.getProgress(this.age, this.lifetime) > 0.8f || this.transparencyData.getProgress(this.age, this.lifetime) > 0.8f) && (this.alpha <= 0.0f || this.getQuadSize(0.0f) <= 0.0f || this.getQuadLength(0.0f) <= 0.0f)) {
            this.remove();
            return;
        }
        this.pickColor(this.colorData.colorCurveEasing.ease(this.colorData.getProgress(this.age, this.lifetime), 0.0f, 1.0f, 1.0f));
        this.quadSize = this.scaleData.getValue(this.age, this.lifetime);
        this.quadLength = this.lengthData != null ? this.lengthData.getValue(this.age, this.lifetime) : this.quadSize;
        this.alpha = Mth.clamp((float)this.transparencyData.getValue(this.age, this.lifetime), (float)0.0f, (float)1.0f);
        this.oRoll = this.roll;
        this.roll += this.spinData.getValue(this.age, this.lifetime);
        if (!this.tickActors.isEmpty()) {
            this.tickActors.forEach(a -> a.accept(this));
        }
        if (this.behavior != null) {
            this.behavior.tick(this);
        }
    }

    public int getLightColor(float pPartialTick) {
        if (this.particleLight == -1) {
            return super.getLightColor(pPartialTick);
        }
        return this.particleLight;
    }

    public void tick() {
        if (this.lifeDelay > 0) {
            --this.lifeDelay;
            return;
        }
        this.updateTraits();
        if (this.spriteSet != null && this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.WITH_AGE)) {
            this.setSpriteFromAge((SpriteSet)this.spriteSet);
        }
        super.tick();
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        if (this.lifeDelay > 0) {
            return;
        }
        this.renderActors.forEach(actor -> actor.accept(this));
        if (this.behavior != null) {
            this.behavior.render(this, this.getVertexConsumer(consumer), camera, partialTicks);
        }
    }

    public ParticleRenderType getRenderType() {
        return this.renderType;
    }

    public float getQuadLength(float partialTicks) {
        return this.quadLength;
    }

    public float getU0() {
        return super.getU0();
    }

    public float getU1() {
        return super.getU1();
    }

    public float getV0() {
        return super.getV0();
    }

    public float getV1() {
        return super.getV1();
    }

    public float getRoll() {
        return this.roll;
    }

    public float getORoll() {
        return this.oRoll;
    }

    public float getRed() {
        return this.rCol;
    }

    public float getGreen() {
        return this.gCol;
    }

    public float getBlue() {
        return this.bCol;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getXOld() {
        return this.xo;
    }

    public double getYOld() {
        return this.yo;
    }

    public double getZOld() {
        return this.zo;
    }

    public double getXMotion() {
        return this.xd;
    }

    public double getYMotion() {
        return this.yd;
    }

    public double getZMotion() {
        return this.zd;
    }

    public Vec3 getParticlePosition() {
        return new Vec3(this.getX(), this.getY(), this.getZ());
    }

    public void setParticlePosition(Vec3 pos) {
        this.setPos(pos.x, pos.y, pos.z);
    }

    public Vec3 getParticleSpeed() {
        return new Vec3(this.getXMotion(), this.getYMotion(), this.getZMotion());
    }

    public void setParticleSpeed(Vec3 speed) {
        this.setParticleSpeed(speed.x, speed.y, speed.z);
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public int getAge() {
        return this.age;
    }

    public RandomSource getRandom() {
        return this.random;
    }

    public void tick(int times) {
        for (int i = 0; i < times; ++i) {
            this.tick();
        }
    }
}

