/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.network.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;

public class NetworkedParticleEffectColorData {
    public static final Codec<NetworkedParticleEffectColorData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ColorParticleData.CODEC.listOf().fieldOf("colors").forGetter(data -> data.colors)).apply((Applicative)instance, NetworkedParticleEffectColorData::new));
    public static final StreamCodec<ByteBuf, NetworkedParticleEffectColorData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    protected final List<ColorParticleData> colors;
    protected int colorCycleCounter;

    public static NetworkedParticleEffectColorData fromColors(List<ColorParticleData> colors) {
        return new NetworkedParticleEffectColorData(colors);
    }

    public static NetworkedParticleEffectColorData fromColor(ColorParticleData color) {
        return NetworkedParticleEffectColorData.fromColors(List.of(color));
    }

    public NetworkedParticleEffectColorData(List<ColorParticleData> colors) {
        this.colors = colors.isEmpty() ? Collections.emptyList() : colors;
    }

    public NetworkedParticleEffectColorData(ColorParticleData ... colors) {
        this(List.of(colors));
    }

    public ColorParticleData getColor() {
        if (this.colors.size() == 1) {
            return this.colors.getFirst();
        }
        return this.colors.get(this.colorCycleCounter++ % this.colors.size());
    }
}

