/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.registry.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.registry.client.LodestoneShaders;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.StateShards;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeData;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeProvider;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;
import team.lodestar.lodestone.systems.rendering.shader.ShaderHolder;

public class LodestoneRenderTypes
extends RenderStateShard {
    public static final Runnable TRANSPARENT_FUNCTION = () -> RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    public static final Runnable ADDITIVE_FUNCTION = () -> RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    public static final RenderStateShard.EmptyTextureStateShard NO_TEXTURE = RenderStateShard.NO_TEXTURE;
    public static final RenderStateShard.LightmapStateShard LIGHTMAP = RenderStateShard.LIGHTMAP;
    public static final RenderStateShard.LightmapStateShard NO_LIGHTMAP = RenderStateShard.NO_LIGHTMAP;
    public static final RenderStateShard.CullStateShard CULL = RenderStateShard.CULL;
    public static final RenderStateShard.CullStateShard NO_CULL = RenderStateShard.NO_CULL;
    public static final RenderStateShard.WriteMaskStateShard COLOR_DEPTH_WRITE = RenderStateShard.COLOR_DEPTH_WRITE;
    public static final RenderStateShard.WriteMaskStateShard COLOR_WRITE = RenderStateShard.COLOR_WRITE;
    public static final HashMap<Pair<Object, LodestoneRenderType>, LodestoneRenderType> COPIES = new HashMap();
    public static final Function<RenderTypeData, LodestoneRenderType> GENERIC = data -> LodestoneRenderTypes.createGenericRenderType(data.name, data.format, data.mode, LodestoneRenderTypes.builder().copyState(data.state));
    private static Consumer<LodestoneCompositeStateBuilder> MODIFIER;
    public static final LodestoneRenderType ADDITIVE_PARTICLE;
    public static final LodestoneRenderType ADDITIVE_BLOCK_PARTICLE;
    public static final LodestoneRenderType ADDITIVE_BLOCK;
    public static final LodestoneRenderType ADDITIVE_SOLID;
    public static final LodestoneRenderType TRANSPARENT_PARTICLE;
    public static final LodestoneRenderType TRANSPARENT_BLOCK_PARTICLE;
    public static final LodestoneRenderType TRANSPARENT_BLOCK;
    public static final LodestoneRenderType TRANSPARENT_SOLID;
    public static final LodestoneRenderType LUMITRANSPARENT_PARTICLE;
    public static final LodestoneRenderType LUMITRANSPARENT_BLOCK_PARTICLE;
    public static final LodestoneRenderType LUMITRANSPARENT_BLOCK;
    public static final LodestoneRenderType LUMITRANSPARENT_SOLID;
    public static final RenderTypeProvider TEXTURE;
    public static final RenderTypeProvider CUTOUT_TEXTURE;
    public static final RenderTypeProvider TRANSPARENT_TEXTURE;
    public static final RenderTypeProvider TRANSPARENT_DISTORTED_TEXTURE;
    public static final RenderTypeProvider TRANSPARENT_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider TRANSPARENT_TWO_SIDED_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider TRANSPARENT_ROUNDED_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider TRANSPARENT_SCROLLING_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider TRANSPARENT_TEXT;
    public static final RenderTypeProvider ADDITIVE_TEXTURE;
    public static final RenderTypeProvider ADDITIVE_DISTORTED_TEXTURE;
    public static final RenderTypeProvider ADDITIVE_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider ADDITIVE_TWO_SIDED_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider ADDITIVE_ROUNDED_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider ADDITIVE_SCROLLING_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider ADDITIVE_TEXT;

    public LodestoneRenderTypes(String p_110161_, Runnable p_110162_, Runnable p_110163_) {
        super(p_110161_, p_110162_, p_110163_);
    }

    public static LodestoneRenderType createGenericRenderType(String name, LodestoneCompositeStateBuilder builder) {
        return LodestoneRenderTypes.createGenericRenderType(name, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, builder);
    }

    public static LodestoneRenderType createGenericRenderType(String name, VertexFormat format, VertexFormat.Mode mode, LodestoneCompositeStateBuilder builder) {
        return LodestoneRenderTypes.createGenericRenderType(name, format, mode, builder, null);
    }

    public static LodestoneRenderType createGenericRenderType(String name, VertexFormat format, VertexFormat.Mode mode, LodestoneCompositeStateBuilder builder, ShaderUniformHandler handler) {
        if (MODIFIER != null) {
            MODIFIER.accept(builder);
        }
        LodestoneRenderType type = LodestoneRenderType.createRenderType(name, format, builder.modeOverride != null ? builder.modeOverride : mode, 256, false, true, builder.createCompositeState(true));
        RenderHandler.addRenderType(type);
        if (handler != null) {
            LodestoneRenderTypes.applyUniformChanges(type, handler);
        }
        MODIFIER = null;
        return type;
    }

    public static LodestoneRenderType copyWithUniformChanges(LodestoneRenderType type, ShaderUniformHandler handler) {
        return LodestoneRenderTypes.applyUniformChanges(LodestoneRenderTypes.copy(type), handler);
    }

    public static LodestoneRenderType copyWithUniformChanges(String newName, LodestoneRenderType type, ShaderUniformHandler handler) {
        return LodestoneRenderTypes.applyUniformChanges(LodestoneRenderTypes.copy(newName, type), handler);
    }

    public static LodestoneRenderType applyUniformChanges(LodestoneRenderType type, ShaderUniformHandler handler) {
        RenderHandler.UNIFORM_HANDLERS.put(type, handler);
        return type;
    }

    public static LodestoneRenderType copy(LodestoneRenderType type) {
        return GENERIC.apply(new RenderTypeData(type));
    }

    public static LodestoneRenderType copy(String newName, LodestoneRenderType type) {
        return GENERIC.apply(new RenderTypeData(newName, type));
    }

    public static LodestoneRenderType copyAndStore(Object index, LodestoneRenderType type) {
        return COPIES.computeIfAbsent((Pair<Object, LodestoneRenderType>)Pair.of((Object)index, (Object)((Object)type)), p -> GENERIC.apply(new RenderTypeData(type)));
    }

    public static LodestoneRenderType copyAndStore(Object index, LodestoneRenderType type, ShaderUniformHandler handler) {
        return LodestoneRenderTypes.applyUniformChanges(LodestoneRenderTypes.copyAndStore(index, type), handler);
    }

    public static void addRenderTypeModifier(Consumer<LodestoneCompositeStateBuilder> modifier) {
        MODIFIER = modifier;
    }

    public static LodestoneCompositeStateBuilder builder(Object ... objects) {
        return LodestoneRenderTypes.builder().setStateShards(objects);
    }

    public static LodestoneCompositeStateBuilder builder() {
        return new LodestoneCompositeStateBuilder();
    }

    static {
        ADDITIVE_PARTICLE = LodestoneRenderTypes.createGenericRenderType("additive_particle", DefaultVertexFormat.PARTICLE, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(TextureAtlas.LOCATION_PARTICLES, StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.PARTICLE, NO_CULL, LIGHTMAP, COLOR_WRITE));
        ADDITIVE_BLOCK_PARTICLE = LodestoneRenderTypes.createGenericRenderType("additive_block_particle", DefaultVertexFormat.PARTICLE, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(TextureAtlas.LOCATION_BLOCKS, StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.PARTICLE, NO_CULL, LIGHTMAP, COLOR_WRITE));
        ADDITIVE_BLOCK = LodestoneRenderTypes.createGenericRenderType("additive_block", LodestoneRenderTypes.builder(TextureAtlas.LOCATION_BLOCKS, StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXTURE, NO_CULL, LIGHTMAP, COLOR_WRITE));
        ADDITIVE_SOLID = LodestoneRenderTypes.createGenericRenderType("additive_solid", DefaultVertexFormat.POSITION_COLOR_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(StateShards.ADDITIVE_TRANSPARENCY, POSITION_COLOR_LIGHTMAP_SHADER, NO_CULL, LIGHTMAP, COLOR_WRITE));
        TRANSPARENT_PARTICLE = LodestoneRenderTypes.createGenericRenderType("transparent_particle", DefaultVertexFormat.PARTICLE, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(TextureAtlas.LOCATION_PARTICLES, StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.PARTICLE, NO_CULL, LIGHTMAP, COLOR_WRITE));
        TRANSPARENT_BLOCK_PARTICLE = LodestoneRenderTypes.createGenericRenderType("transparent_block_particle", DefaultVertexFormat.PARTICLE, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(TextureAtlas.LOCATION_BLOCKS, StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.PARTICLE, NO_CULL, LIGHTMAP, COLOR_WRITE));
        TRANSPARENT_BLOCK = LodestoneRenderTypes.createGenericRenderType("transparent_block", LodestoneRenderTypes.builder(TextureAtlas.LOCATION_BLOCKS, StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXTURE, NO_CULL, LIGHTMAP, COLOR_WRITE));
        TRANSPARENT_SOLID = LodestoneRenderTypes.createGenericRenderType("transparent_solid", DefaultVertexFormat.POSITION_COLOR_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(StateShards.NORMAL_TRANSPARENCY, POSITION_COLOR_LIGHTMAP_SHADER, NO_CULL, LIGHTMAP, COLOR_WRITE));
        LUMITRANSPARENT_PARTICLE = LodestoneRenderTypes.copyWithUniformChanges("lodestone:lumitransparent_particle", TRANSPARENT_PARTICLE, ShaderUniformHandler.LUMITRANSPARENT);
        LUMITRANSPARENT_BLOCK_PARTICLE = LodestoneRenderTypes.copyWithUniformChanges("lodestone:lumitransparent_block_particle", TRANSPARENT_BLOCK_PARTICLE, ShaderUniformHandler.LUMITRANSPARENT);
        LUMITRANSPARENT_BLOCK = LodestoneRenderTypes.copyWithUniformChanges("lodestone:lumitransparent_block", TRANSPARENT_BLOCK, ShaderUniformHandler.LUMITRANSPARENT);
        LUMITRANSPARENT_SOLID = LodestoneRenderTypes.copyWithUniformChanges("lodestone:lumitransparent_solid", TRANSPARENT_SOLID, ShaderUniformHandler.LUMITRANSPARENT);
        TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("texture", LodestoneRenderTypes.builder(token, StateShards.NO_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXTURE, CULL, LIGHTMAP)));
        CUTOUT_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("cutout_texture", LodestoneRenderTypes.builder(token, StateShards.NO_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXTURE, CULL, LIGHTMAP)));
        TRANSPARENT_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("transparent_texture", LodestoneRenderTypes.builder(token, StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXTURE, CULL, LIGHTMAP, COLOR_WRITE)));
        TRANSPARENT_DISTORTED_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("distorted_transparent_texture", LodestoneRenderTypes.builder(token, StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.DISTORTED_TEXTURE, CULL, LIGHTMAP, COLOR_WRITE)));
        TRANSPARENT_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("transparent_texture_triangle", LodestoneRenderTypes.builder(token, StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.TRIANGLE_TEXTURE, CULL, LIGHTMAP, COLOR_WRITE)));
        TRANSPARENT_TWO_SIDED_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("transparent_two_sided_texture_triangle", LodestoneRenderTypes.builder(token, StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.TWO_SIDED_TRIANGLE_TEXTURE, CULL, LIGHTMAP, COLOR_WRITE)));
        TRANSPARENT_ROUNDED_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("transparent_rounded_texture_triangle", LodestoneRenderTypes.builder(token, StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.ROUNDED_TRIANGLE_TEXTURE, CULL, LIGHTMAP, COLOR_WRITE)));
        TRANSPARENT_SCROLLING_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("transparent_scrolling_texture_triangle", LodestoneRenderTypes.builder(token, StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.SCROLLING_TRIANGLE_TEXTURE, CULL, LIGHTMAP, COLOR_WRITE)));
        TRANSPARENT_TEXT = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("transparent_text", LodestoneRenderTypes.builder(token, StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXT, LIGHTMAP)));
        ADDITIVE_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("additive_texture", LodestoneRenderTypes.builder(token, StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXTURE, CULL, LIGHTMAP, COLOR_WRITE)));
        ADDITIVE_DISTORTED_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("distorted_additive_texture", LodestoneRenderTypes.builder(token, StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.DISTORTED_TEXTURE, CULL, LIGHTMAP, COLOR_WRITE)));
        ADDITIVE_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("additive_texture_triangle", LodestoneRenderTypes.builder(token, StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.TRIANGLE_TEXTURE, CULL, LIGHTMAP, COLOR_WRITE)));
        ADDITIVE_TWO_SIDED_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("additive_two_sided_texture_triangle", LodestoneRenderTypes.builder(token, StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.TWO_SIDED_TRIANGLE_TEXTURE, CULL, LIGHTMAP, COLOR_WRITE)));
        ADDITIVE_ROUNDED_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("additive_rounded_texture_triangle", LodestoneRenderTypes.builder(token, StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.ROUNDED_TRIANGLE_TEXTURE, CULL, LIGHTMAP, COLOR_WRITE)));
        ADDITIVE_SCROLLING_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("additive_scrolling_texture_triangle", LodestoneRenderTypes.builder(token, StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.SCROLLING_TRIANGLE_TEXTURE, CULL, LIGHTMAP, COLOR_WRITE)));
        ADDITIVE_TEXT = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType("additive_text", LodestoneRenderTypes.builder(token, StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXT, LIGHTMAP, COLOR_WRITE)));
    }

    public static class LodestoneCompositeStateBuilder
    extends RenderType.CompositeState.CompositeStateBuilder {
        protected VertexFormat.Mode modeOverride;

        LodestoneCompositeStateBuilder() {
        }

        public LodestoneCompositeStateBuilder replaceVertexFormat(VertexFormat.Mode mode) {
            this.modeOverride = mode;
            return this;
        }

        public LodestoneCompositeStateBuilder copyState(RenderType.CompositeState state) {
            for (RenderStateShard renderStateShard : state.states) {
                this.setStateShards(renderStateShard);
            }
            return this;
        }

        public LodestoneCompositeStateBuilder setStateShards(Object ... objects) {
            for (Object object : objects) {
                if (object instanceof ResourceLocation) {
                    ResourceLocation texture = (ResourceLocation)object;
                    this.setTextureState(texture);
                    continue;
                }
                if (object instanceof RenderTypeToken) {
                    RenderTypeToken token = (RenderTypeToken)object;
                    this.setTextureState(token.get());
                    continue;
                }
                if (object instanceof RenderStateShard.EmptyTextureStateShard) {
                    RenderStateShard.EmptyTextureStateShard shard = (RenderStateShard.EmptyTextureStateShard)object;
                    this.setTextureState(shard);
                    continue;
                }
                if (object instanceof ShaderHolder) {
                    ShaderHolder shaderHolder = (ShaderHolder)object;
                    this.setShaderState(shaderHolder);
                    continue;
                }
                if (object instanceof RenderStateShard.ShaderStateShard) {
                    RenderStateShard.ShaderStateShard shard = (RenderStateShard.ShaderStateShard)object;
                    this.setShaderState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.TransparencyStateShard) {
                    RenderStateShard.TransparencyStateShard shard = (RenderStateShard.TransparencyStateShard)object;
                    this.setTransparencyState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.DepthTestStateShard) {
                    RenderStateShard.DepthTestStateShard shard = (RenderStateShard.DepthTestStateShard)object;
                    this.setDepthTestState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.CullStateShard) {
                    RenderStateShard.CullStateShard shard = (RenderStateShard.CullStateShard)object;
                    this.setCullState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.LightmapStateShard) {
                    RenderStateShard.LightmapStateShard shard = (RenderStateShard.LightmapStateShard)object;
                    this.setLightmapState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.OverlayStateShard) {
                    RenderStateShard.OverlayStateShard shard = (RenderStateShard.OverlayStateShard)object;
                    this.setOverlayState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.LayeringStateShard) {
                    RenderStateShard.LayeringStateShard shard = (RenderStateShard.LayeringStateShard)object;
                    this.setLayeringState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.OutputStateShard) {
                    RenderStateShard.OutputStateShard shard = (RenderStateShard.OutputStateShard)object;
                    this.setOutputState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.TexturingStateShard) {
                    RenderStateShard.TexturingStateShard shard = (RenderStateShard.TexturingStateShard)object;
                    this.setTexturingState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.WriteMaskStateShard) {
                    RenderStateShard.WriteMaskStateShard shard = (RenderStateShard.WriteMaskStateShard)object;
                    this.setWriteMaskState(shard);
                    continue;
                }
                if (object instanceof RenderStateShard.LineStateShard) {
                    RenderStateShard.LineStateShard shard = (RenderStateShard.LineStateShard)object;
                    this.setLineState(shard);
                    continue;
                }
                if (!(object instanceof RenderStateShard.ColorLogicStateShard)) continue;
                RenderStateShard.ColorLogicStateShard shard = (RenderStateShard.ColorLogicStateShard)object;
                this.setColorLogicState(shard);
            }
            return this;
        }

        public LodestoneCompositeStateBuilder setTextureState(ResourceLocation texture) {
            return this.setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false));
        }

        public LodestoneCompositeStateBuilder setShaderState(ShaderHolder shaderHolder) {
            return this.setShaderState(shaderHolder.getShard());
        }

        public LodestoneCompositeStateBuilder setTextureState(RenderStateShard.EmptyTextureStateShard pTextureState) {
            return (LodestoneCompositeStateBuilder)super.setTextureState(pTextureState);
        }

        public LodestoneCompositeStateBuilder setShaderState(RenderStateShard.ShaderStateShard pShaderState) {
            return (LodestoneCompositeStateBuilder)super.setShaderState(pShaderState);
        }

        public LodestoneCompositeStateBuilder setTransparencyState(RenderStateShard.TransparencyStateShard pTransparencyState) {
            return (LodestoneCompositeStateBuilder)super.setTransparencyState(pTransparencyState);
        }

        public LodestoneCompositeStateBuilder setDepthTestState(RenderStateShard.DepthTestStateShard pDepthTestState) {
            return (LodestoneCompositeStateBuilder)super.setDepthTestState(pDepthTestState);
        }

        public LodestoneCompositeStateBuilder setCullState(RenderStateShard.CullStateShard pCullState) {
            return (LodestoneCompositeStateBuilder)super.setCullState(pCullState);
        }

        public LodestoneCompositeStateBuilder setLightmapState(RenderStateShard.LightmapStateShard pLightmapState) {
            return (LodestoneCompositeStateBuilder)super.setLightmapState(pLightmapState);
        }

        public LodestoneCompositeStateBuilder setOverlayState(RenderStateShard.OverlayStateShard pOverlayState) {
            return (LodestoneCompositeStateBuilder)super.setOverlayState(pOverlayState);
        }

        public LodestoneCompositeStateBuilder setLayeringState(RenderStateShard.LayeringStateShard pLayerState) {
            return (LodestoneCompositeStateBuilder)super.setLayeringState(pLayerState);
        }

        public LodestoneCompositeStateBuilder setOutputState(RenderStateShard.OutputStateShard pOutputState) {
            return (LodestoneCompositeStateBuilder)super.setOutputState(pOutputState);
        }

        public LodestoneCompositeStateBuilder setTexturingState(RenderStateShard.TexturingStateShard pTexturingState) {
            return (LodestoneCompositeStateBuilder)super.setTexturingState(pTexturingState);
        }

        public LodestoneCompositeStateBuilder setWriteMaskState(RenderStateShard.WriteMaskStateShard pWriteMaskState) {
            return (LodestoneCompositeStateBuilder)super.setWriteMaskState(pWriteMaskState);
        }

        public LodestoneCompositeStateBuilder setLineState(RenderStateShard.LineStateShard pLineState) {
            return (LodestoneCompositeStateBuilder)super.setLineState(pLineState);
        }
    }
}

