/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.network.screenshake;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import team.lodestar.lodestone.handlers.ScreenshakeHandler;
import team.lodestar.lodestone.helpers.ReflectionHelper;
import team.lodestar.lodestone.network.screenshake.ScreenshakePayload;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.screenshake.PositionedScreenshakeInstance;

public class PositionedScreenshakePayload
extends ScreenshakePayload {
    public Vec3 position;
    public float falloffDistance;
    public float maxDistance;
    public Easing falloffEasing;
    public static final Codec<PositionedScreenshakePayload> CODEC = RecordCodecBuilder.create(obj -> obj.group((App)ScreenshakePayload.CODEC.fieldOf("parent").forGetter(p -> p), (App)Vec3.CODEC.fieldOf("position").forGetter(p -> p.position), (App)Codec.FLOAT.fieldOf("falloffDistance").forGetter(p -> Float.valueOf(p.falloffDistance)), (App)Codec.FLOAT.fieldOf("maxDistance").forGetter(p -> Float.valueOf(p.maxDistance)), (App)Easing.CODEC.fieldOf("falloffEasing").forGetter(p -> p.falloffEasing)).apply((Applicative)obj, PositionedScreenshakePayload::new));
    public static final StreamCodec<ByteBuf, PositionedScreenshakePayload> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);

    public PositionedScreenshakePayload(FriendlyByteBuf byteBuf) {
        super(byteBuf);
        ReflectionHelper.copyFields(this, (PositionedScreenshakePayload)STREAM_CODEC.decode((Object)byteBuf), new String[0]);
    }

    public PositionedScreenshakePayload(ScreenshakePayload parent, Vec3 position, float falloffDistance, float maxDistance, Easing falloffEasing) {
        this(parent.duration, parent.intensity1, parent.intensity2, parent.intensity3, parent.intensityCurveStartEasing, parent.intensityCurveEndEasing, position, falloffDistance, maxDistance, falloffEasing);
    }

    public PositionedScreenshakePayload(int duration, float intensity1, float intensity2, float intensity3, Easing intensityCurveStartEasing, Easing intensityCurveEndEasing, Vec3 position, float falloffDistance, float maxDistance, Easing falloffEasing) {
        super(duration, intensity1, intensity2, intensity3, intensityCurveStartEasing, intensityCurveEndEasing);
        this.position = position;
        this.falloffDistance = falloffDistance;
        this.maxDistance = maxDistance;
        this.falloffEasing = falloffEasing;
    }

    @Override
    public void handle(IPayloadContext context) {
        ScreenshakeHandler.addScreenshake(new PositionedScreenshakeInstance(this.duration, this.position, this.falloffDistance, this.maxDistance, this.falloffEasing).setIntensity(this.intensity1, this.intensity2, this.intensity3).setEasing(this.intensityCurveStartEasing, this.intensityCurveEndEasing));
    }

    @Override
    public void serialize(FriendlyByteBuf byteBuf) {
        STREAM_CODEC.encode((Object)byteBuf, (Object)this);
    }
}

