/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.shader;

import com.mojang.blaze3d.shaders.ProgramManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL43;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.systems.rendering.IBufferObject;

public class ComputeProgram
implements IBufferObject {
    private int programId;
    private Shader shader;
    private ResourceLocation shaderLocation;

    public ComputeProgram(ResourceLocation shaderLocation) {
        this.shaderLocation = shaderLocation;
        this.registerBufferObject();
    }

    public void register(RegisterShadersEvent event) {
        ResourceProvider provider = event.getResourceProvider();
        LodestoneLib.LOGGER.info("Registering compute shader: " + String.valueOf(this.shaderLocation));
        this.loadShader(provider);
    }

    private void loadShader(ResourceProvider provider) {
        this.destroy();
        try {
            this.programId = ProgramManager.createProgram();
            LodestoneLib.LOGGER.info("Created compute shader program: " + this.programId);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create compute shader program");
        }
        this.shader = new Shader(provider, this.shaderLocation);
        GL43.glAttachShader((int)this.programId, (int)this.shader.getId());
        GL43.glLinkProgram((int)this.programId);
    }

    public void bind() {
        ProgramManager.glUseProgram((int)this.programId);
    }

    @Override
    public void destroy() {
        if (this.programId != 0) {
            GL43.glDeleteProgram((int)this.programId);
        }
        if (this.shader != null && this.shader.getId() != 0) {
            GL43.glDeleteShader((int)this.shader.getId());
        }
        this.programId = 0;
        this.shader = null;
    }

    @Override
    public void registerBufferObject() {
        IBufferObject.super.registerBufferObject();
    }

    public static class Shader {
        private int shaderId;
        private String source;

        public Shader(ResourceProvider provider, ResourceLocation shaderLocation) {
            ResourceLocation shaderLocation1 = ResourceLocation.fromNamespaceAndPath((String)shaderLocation.getNamespace(), (String)("shaders/compute/" + shaderLocation.getPath()));
            try {
                this.source = this.openResource(provider.getResourceOrThrow(shaderLocation1));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to open resource: " + String.valueOf(shaderLocation1));
            }
            LodestoneLib.LOGGER.info("Shader source: " + this.source);
            this.compile();
        }

        private String openResource(Resource resource) {
            String result;
            try (InputStream stream = resource.open();){
                result = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open resource: " + String.valueOf(resource), e);
            }
            return result;
        }

        public void compile() {
            this.shaderId = GL43.glCreateShader((int)37305);
            GL43.glShaderSource((int)this.shaderId, (CharSequence)this.source);
            GL43.glCompileShader((int)this.shaderId);
            if (GL43.glGetShaderi((int)this.shaderId, (int)35713) == 0) {
                throw new RuntimeException("Failed to compile shader: " + GL43.glGetShaderInfoLog((int)this.shaderId, (int)1024));
            }
        }

        public int getId() {
            return this.shaderId;
        }
    }
}

