/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.world.behaviors;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;

public class SparkParticleBehavior
implements LodestoneParticleBehavior {
    private static final VFXBuilders.WorldVFXBuilder SPARK_BUILDER = VFXBuilders.createWorld().setFormat(DefaultVertexFormat.PARTICLE);
    protected final GenericParticleData lengthData;
    protected Vec3 forcedDirection;
    protected Vec3 cachedDirection;

    public SparkParticleBehavior(GenericParticleData lengthData) {
        this.lengthData = lengthData;
    }

    public SparkParticleBehavior() {
        this(null);
    }

    @Override
    public void render(LodestoneWorldParticle particle, VertexConsumer consumer, Camera camera, float partialTicks) {
        Vec3 vec3 = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTicks, (double)particle.getXOld(), (double)particle.getX()) - vec3.x());
        float y = (float)(Mth.lerp((double)partialTicks, (double)particle.getYOld(), (double)particle.getY()) - vec3.y());
        float z = (float)(Mth.lerp((double)partialTicks, (double)particle.getZOld(), (double)particle.getZ()) - vec3.z());
        Vec3 pos = new Vec3((double)x, (double)y, (double)z);
        GenericParticleData lengthData = this.getLengthData(particle);
        float length = lengthData.getValue(particle.getAge(), particle.getLifetime());
        Vec3 offset = this.getDirection(particle).scale((double)length);
        Vec3 movingFrom = this.sparkStart(pos, offset);
        Vec3 movingTo = this.sparkEnd(pos, offset);
        SPARK_BUILDER.setVertexConsumer(consumer).setUV(particle.getU0(), particle.getV0(), particle.getU1(), particle.getV1()).setColorRaw(particle.getRed(), particle.getGreen(), particle.getBlue()).setAlpha(particle.getAlpha()).renderBeam(null, movingFrom, movingTo, particle.getQuadSize(partialTicks), Vec3.ZERO);
    }

    @Override
    public void tick(LodestoneWorldParticle particle) {
        Vec3 direction = particle.getParticleSpeed().normalize();
        if (!direction.equals((Object)Vec3.ZERO)) {
            this.cachedDirection = direction;
        }
    }

    public SparkParticleBehavior setForcedDirection(Vec3 forcedDirection) {
        this.forcedDirection = forcedDirection;
        return this;
    }

    public GenericParticleData getLengthData(LodestoneWorldParticle particle) {
        return this.getLengthData() != null ? this.getLengthData() : particle.scaleData;
    }

    public Vec3 getDirection(LodestoneWorldParticle particle) {
        if (this.forcedDirection != null) {
            return this.forcedDirection;
        }
        return this.getCachedDirection() != null ? this.getCachedDirection() : particle.getParticleSpeed().normalize();
    }

    public GenericParticleData getLengthData() {
        return this.lengthData;
    }

    public Vec3 getCachedDirection() {
        return this.cachedDirection;
    }

    public Vec3 sparkStart(Vec3 pos, Vec3 offset) {
        return pos.subtract(offset);
    }

    public Vec3 sparkEnd(Vec3 pos, Vec3 offset) {
        return pos.add(offset);
    }
}

