/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.world.behaviors;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;

public class PointyDirectionalParticleBehavior
implements LodestoneParticleBehavior {
    private final Function<LodestoneWorldParticle, Vec3> direction;

    protected PointyDirectionalParticleBehavior(Function<LodestoneWorldParticle, Vec3> direction) {
        this.direction = direction;
    }

    public PointyDirectionalParticleBehavior(Vec3 direction) {
        this((LodestoneWorldParticle p) -> direction);
    }

    public PointyDirectionalParticleBehavior() {
        this((LodestoneWorldParticle p) -> p.getParticleSpeed().normalize());
    }

    public Vec3 getDirection(LodestoneWorldParticle particle) {
        return this.direction.apply(particle);
    }

    @Override
    public void render(LodestoneWorldParticle particle, VertexConsumer consumer, Camera camera, float partialTicks) {
        Vec3 direction = this.getDirection(particle);
        float yRot = (float)(Mth.atan2((double)direction.x, (double)direction.z) * 57.2957763671875);
        float xRot = (float)(Mth.atan2((double)direction.y, (double)direction.horizontalDistance()) * 57.2957763671875);
        float yaw = (float)Math.toRadians(yRot - 90.0f);
        float pitch = (float)Math.toRadians(xRot);
        Quaternionf quaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        quaternion.mul((Quaternionfc)this.oldSchool(0.0f, yaw, 0.0f));
        quaternion.mul((Quaternionfc)this.oldSchool(0.0f, 0.0f, pitch));
        if (particle.getRoll() != 0.0f) {
            quaternion.rotateX(Mth.lerp((float)partialTicks, (float)particle.getORoll(), (float)particle.getRoll()));
        }
        Vec3 vec3 = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTicks, (double)particle.getXOld(), (double)particle.getX()) - vec3.x());
        float y = (float)(Mth.lerp((double)partialTicks, (double)particle.getYOld(), (double)particle.getY()) - vec3.y());
        float z = (float)(Mth.lerp((double)partialTicks, (double)particle.getZOld(), (double)particle.getZ()) - vec3.z());
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, -1.0f)};
        float f4 = particle.getQuadSize(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(x, y, z);
        }
        float f7 = particle.getU0();
        float f8 = particle.getU1();
        float f5 = particle.getV0();
        float f6 = particle.getV1();
        int j = particle.getLightColor(partialTicks);
        float red = particle.getRed();
        float green = particle.getGreen();
        float blue = particle.getBlue();
        float alpha = particle.getAlpha();
        consumer.addVertex(avector3f[0].x(), avector3f[0].y(), avector3f[0].z()).setUv(f8, f6).setColor(red, green, blue, alpha).setLight(j);
        consumer.addVertex(avector3f[1].x(), avector3f[1].y(), avector3f[1].z()).setUv(f8, f5).setColor(red, green, blue, alpha).setLight(j);
        consumer.addVertex(avector3f[2].x(), avector3f[2].y(), avector3f[2].z()).setUv(f7, f5).setColor(red, green, blue, alpha).setLight(j);
        consumer.addVertex(avector3f[3].x(), avector3f[3].y(), avector3f[3].z()).setUv(f7, f6).setColor(red, green, blue, alpha).setLight(j);
    }

    public Quaternionf oldSchool(float pX, float pY, float pZ) {
        float f = Mth.sin((float)(0.5f * pX));
        float f1 = Mth.cos((float)(0.5f * pX));
        float f2 = Mth.sin((float)(0.5f * pY));
        float f3 = Mth.cos((float)(0.5f * pY));
        float f4 = Mth.sin((float)(0.5f * pZ));
        float f5 = Mth.cos((float)(0.5f * pZ));
        float x = f * f3 * f5 + f1 * f2 * f4;
        float y = f1 * f2 * f5 - f * f3 * f4;
        float z = f * f2 * f5 + f1 * f3 * f4;
        float w = f1 * f3 * f5 - f * f2 * f4;
        return new Quaternionf(x, y, z, w);
    }
}

