/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.data.color;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import net.minecraft.util.Mth;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataBuilder;

public class ColorParticleData {
    public static final Codec<ColorParticleData> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)Codec.FLOAT.fieldOf("r1").forGetter(data -> Float.valueOf(data.r1)), (App)Codec.FLOAT.fieldOf("g1").forGetter(data -> Float.valueOf(data.g1)), (App)Codec.FLOAT.fieldOf("b1").forGetter(data -> Float.valueOf(data.b1)), (App)Codec.FLOAT.fieldOf("r2").forGetter(data -> Float.valueOf(data.r2)), (App)Codec.FLOAT.fieldOf("g2").forGetter(data -> Float.valueOf(data.g2)), (App)Codec.FLOAT.fieldOf("b2").forGetter(data -> Float.valueOf(data.b2)), (App)Codec.FLOAT.fieldOf("colorCoefficient").forGetter(data -> Float.valueOf(data.colorCoefficient)), (App)Easing.CODEC.fieldOf("colorCurveEasing").forGetter(data -> data.colorCurveEasing), (App)Codec.FLOAT.fieldOf("coefficientMultiplier").forGetter(data -> Float.valueOf(data.coefficientMultiplier))).apply((Applicative)instance, ColorParticleData::new));
    public final float r1;
    public final float g1;
    public final float b1;
    public final float r2;
    public final float g2;
    public final float b2;
    public final float colorCoefficient;
    public final Easing colorCurveEasing;
    public float coefficientMultiplier = 1.0f;

    protected ColorParticleData(float r1, float g1, float b1, float r2, float g2, float b2, float colorCoefficient, Easing colorCurveEasing, float coefficientMultiplier) {
        this(r1, g1, b1, r2, g2, b2, colorCoefficient, colorCurveEasing);
        this.coefficientMultiplier = coefficientMultiplier;
    }

    protected ColorParticleData(float r1, float g1, float b1, float r2, float g2, float b2, float colorCoefficient, Easing colorCurveEasing) {
        this.r1 = r1;
        this.g1 = g1;
        this.b1 = b1;
        this.r2 = r2;
        this.g2 = g2;
        this.b2 = b2;
        this.colorCoefficient = colorCoefficient;
        this.colorCurveEasing = colorCurveEasing;
    }

    public ColorParticleData multiplyCoefficient(float coefficientMultiplier) {
        this.coefficientMultiplier *= coefficientMultiplier;
        return this;
    }

    public ColorParticleData overrideCoefficientMultiplier(float coefficientMultiplier) {
        this.coefficientMultiplier = coefficientMultiplier;
        return this;
    }

    public float getProgress(float age, float lifetime) {
        return Mth.clamp((float)(age * this.colorCoefficient * this.coefficientMultiplier / lifetime), (float)0.0f, (float)1.0f);
    }

    public Color getStartingColor() {
        return new Color(this.r1, this.g1, this.b1);
    }

    public Color getEndingColor() {
        return new Color(this.r2, this.g2, this.b2);
    }

    public ColorParticleDataBuilder invert() {
        return ColorParticleData.create(this.r2, this.g2, this.b2, this.r1, this.g1, this.b1).setCoefficient(this.colorCoefficient).setEasing(this.colorCurveEasing);
    }

    public ColorParticleDataBuilder copy() {
        return ColorParticleData.create(this.r1, this.g1, this.b1, this.r2, this.g2, this.b2).setCoefficient(this.colorCoefficient).setEasing(this.colorCurveEasing);
    }

    public static ColorParticleDataBuilder create(float r1, float g1, float b1, float r2, float g2, float b2) {
        return new ColorParticleDataBuilder(r1, g1, b1, r2, g2, b2);
    }

    public static ColorParticleDataBuilder create(float r, float g, float b) {
        return new ColorParticleDataBuilder(r, g, b, r, g, b);
    }

    public static ColorParticleDataBuilder create(Color start, Color end) {
        return ColorParticleData.create((float)start.getRed() / 255.0f, (float)start.getGreen() / 255.0f, (float)start.getBlue() / 255.0f, (float)end.getRed() / 255.0f, (float)end.getGreen() / 255.0f, (float)end.getBlue() / 255.0f);
    }

    public static ColorParticleDataBuilder create(Color color) {
        return ColorParticleData.create((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
    }
}

