/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.registry.common;

import java.util.HashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamMemberEncoder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import team.lodestar.lodestone.network.TotemOfUndyingPayload;
import team.lodestar.lodestone.network.screenshake.PositionedScreenshakePayload;
import team.lodestar.lodestone.network.screenshake.ScreenshakePayload;
import team.lodestar.lodestone.network.worldevent.SyncWorldEventPayload;
import team.lodestar.lodestone.network.worldevent.UpdateWorldEventPayload;
import team.lodestar.lodestone.systems.network.LodestoneNetworkPayloadData;
import team.lodestar.lodestone.systems.network.OneSidedPayloadData;
import team.lodestar.lodestone.systems.network.TwoSidedPayloadData;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class LodestoneNetworkPayloads {
    public static final PayloadRegistryHelper LODESTONE_CHANNEL = new PayloadRegistryHelper("lodestone");

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        LODESTONE_CHANNEL.playToClient(registrar, "totem_of_undying", TotemOfUndyingPayload.class, TotemOfUndyingPayload::new);
        LODESTONE_CHANNEL.playToClient(registrar, "sync_world_event", SyncWorldEventPayload.class, SyncWorldEventPayload::new);
        LODESTONE_CHANNEL.playToClient(registrar, "update_world_event", UpdateWorldEventPayload.class, UpdateWorldEventPayload::new);
        LODESTONE_CHANNEL.playToClient(registrar, "screenshake", ScreenshakePayload.class, ScreenshakePayload::new);
        LODESTONE_CHANNEL.playToClient(registrar, "positioned_screenshake", PositionedScreenshakePayload.class, PositionedScreenshakePayload::new);
    }

    public static class PayloadRegistryHelper {
        public static final HashMap<Class<? extends LodestoneNetworkPayloadData>, CustomPacketPayload.Type<? extends LodestoneNetworkPayloadData>> PAYLOAD_TO_TYPE = new HashMap();
        public final String namespace;

        public PayloadRegistryHelper(String namespace) {
            this.namespace = namespace;
        }

        public <T extends OneSidedPayloadData> void playToClient(PayloadRegistrar registrar, String name, Class<T> clazz, PayloadDataSupplier<T> decoder) {
            CustomPacketPayload.Type<T> type = this.createPayloadType(clazz, name);
            registrar.playToClient(type, this.createCodec(decoder), OneSidedPayloadData::handle);
        }

        public <T extends OneSidedPayloadData> void playToServer(PayloadRegistrar registrar, String name, Class<T> clazz, PayloadDataSupplier<T> decoder) {
            CustomPacketPayload.Type<T> type = this.createPayloadType(clazz, name);
            registrar.playToServer(type, this.createCodec(decoder), OneSidedPayloadData::handle);
        }

        public <T extends TwoSidedPayloadData> void playBidirectional(PayloadRegistrar registrar, String name, Class<T> clazz, PayloadDataSupplier<T> decoder) {
            CustomPacketPayload.Type<T> type = this.createPayloadType(clazz, name);
            registrar.playBidirectional(type, this.createCodec(decoder), (IPayloadHandler)new DirectionalPayloadHandler(TwoSidedPayloadData::handleClient, TwoSidedPayloadData::handleServer));
        }

        public <T extends LodestoneNetworkPayloadData> StreamCodec<FriendlyByteBuf, T> createCodec(PayloadDataSupplier<T> supplier) {
            return StreamCodec.ofMember(this.encodePacket(), this.decodePacket(supplier));
        }

        public final <B extends FriendlyByteBuf, T extends LodestoneNetworkPayloadData> StreamMemberEncoder<B, T> encodePacket() {
            return LodestoneNetworkPayloadData::serialize;
        }

        public final <B extends FriendlyByteBuf, T extends LodestoneNetworkPayloadData> StreamDecoder<B, T> decodePacket(PayloadDataSupplier<T> supplier) {
            return byteBuf -> {
                try {
                    return supplier.createPayload((FriendlyByteBuf)byteBuf);
                }
                catch (Exception e) {
                    throw new RuntimeException("Couldn't decode payload type from channel " + this.namespace, e);
                }
            };
        }

        public <T extends LodestoneNetworkPayloadData> CustomPacketPayload.Type<T> createPayloadType(Class<T> clazz, String id) {
            CustomPacketPayload.Type type = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)id));
            PAYLOAD_TO_TYPE.put(clazz, (CustomPacketPayload.Type<? extends LodestoneNetworkPayloadData>)type);
            return type;
        }
    }

    public static interface PayloadDataSupplier<T extends LodestoneNetworkPayloadData> {
        public T createPayload(FriendlyByteBuf var1);
    }
}

