/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ReflectionHelper {
    public static <T> void copyFields(T from, T to, String ... fieldNames) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (fieldNames.length == 0) {
            fields.addAll(List.of(from.getClass().getDeclaredFields()));
        } else {
            Set<String> fieldNameSet = Set.of(fieldNames);
            fields.addAll(Arrays.stream(from.getClass().getDeclaredFields()).filter(f -> fieldNameSet.contains(f.getName())).toList());
        }
        for (Field field : fields) {
            try {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                field.set(to, field.get(from));
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    public static <T> Optional<T> getField(String name, Object object) {
        try {
            Field field = object.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return Optional.of(field.get(object));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return Optional.empty();
        }
    }
}

